/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequence;

import org.sing_group.seda.core.trim.StringTrimmer;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.transformation.sequence.SequenceTransformation;

public class TrimSequenceTransformation
implements SequenceTransformation {
    private final SequenceBuilder builder = factory::newSequence;
    private final int leading;
    private final int trailing;

    public TrimSequenceTransformation(int leading, int trailing) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), leading, trailing);
    }

    public TrimSequenceTransformation(DatatypeFactory factory, int leading, int trailing) {
        this.leading = leading;
        this.trailing = trailing;
    }

    @Override
    public Sequence transform(Sequence sequence) {
        String chain = new StringTrimmer(this.leading, this.trailing).trim(sequence.getChain());
        return this.builder.of(sequence.getName(), sequence.getDescription(), chain, sequence.getProperties());
    }
}

