/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.split;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.split.AbstractSequencesGroupSplitter;
import org.sing_group.seda.core.split.DefaultSequencesSort;
import org.sing_group.seda.core.split.NumberOfFilesSplitter;
import org.sing_group.seda.core.split.NumberOfSequencesAndNumberOfFilesSplitter;
import org.sing_group.seda.core.split.NumberOfSequencesAndNumberOfFilesWithIndependentExtractionsSplitter;
import org.sing_group.seda.core.split.NumberOfSequencesSplitter;
import org.sing_group.seda.core.split.RandomSequencesSort;
import org.sing_group.seda.core.split.SequencesGroupSplitMode;
import org.sing_group.seda.core.split.SequencesSort;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SplitSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.split.SplitConfigurationEventType;

@XmlRootElement
public class SplitConfigurationTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private SequencesGroupSplitMode splitMode;
    @XmlElement
    private boolean randomize;
    @XmlElement
    private int randomSeed;
    @XmlElement
    private boolean independentExtractions;
    @XmlElement
    private int numFiles;
    @XmlElement
    private int numSequences;

    public SplitConfigurationTransformationProvider() {
    }

    public SplitConfigurationTransformationProvider(SequencesGroupSplitMode splitMode, boolean randomize, int randomSeed, boolean independentExtractions, int numFiles, int numSequences) {
        this.splitMode = splitMode;
        this.randomize = randomize;
        this.numSequences = numSequences;
        this.randomSeed = randomSeed;
        this.numFiles = numFiles;
        this.numSequences = numSequences;
        this.independentExtractions = independentExtractions;
    }

    @Override
    public Validation validate() {
        return this.splitMode == null ? new DefaultValidation("Split mode can't be null.") : new DefaultValidation(new String[0]);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        AbstractSequencesGroupSplitter splitter;
        switch (this.getSplitMode()) {
            case FIXED_FILES: {
                splitter = new NumberOfFilesSplitter(this.getNumFiles(), this.getSequencesSort(), factory);
                break;
            }
            case FIXED_SEQUENCES_PER_FILE: {
                splitter = new NumberOfSequencesSplitter(this.getNumSequences(), this.getSequencesSort(), factory);
                break;
            }
            case SEQUENCES_PER_FILE_AND_FILES: {
                if (this.isIndependentExtractions()) {
                    splitter = new NumberOfSequencesAndNumberOfFilesWithIndependentExtractionsSplitter(this.getNumFiles(), this.getNumSequences(), this.getSequencesSort(), factory);
                    break;
                }
                splitter = new NumberOfSequencesAndNumberOfFilesSplitter(this.getNumFiles(), this.getNumSequences(), this.getSequencesSort(), factory);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal split mode");
            }
        }
        return new SplitSequencesGroupDatasetTransformation(splitter, factory);
    }

    public SequencesGroupSplitMode getSplitMode() {
        return this.splitMode;
    }

    public int getNumSequences() {
        return this.numSequences;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    private SequencesSort getSequencesSort() {
        if (this.isRandomize()) {
            return new RandomSequencesSort(this.getRandomSeed());
        }
        return new DefaultSequencesSort();
    }

    public int getRandomSeed() {
        return this.randomSeed;
    }

    public boolean isIndependentExtractions() {
        return this.independentExtractions;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        if (this.randomize != randomize) {
            this.randomize = randomize;
            this.fireTransformationsConfigurationModelEvent(SplitConfigurationEventType.RANDOMIZE_SELECTION_CHANGED, this.isRandomize());
        }
    }

    public void setRandomSeed(int randomSeed) {
        if (this.randomSeed != randomSeed) {
            this.randomSeed = randomSeed;
            this.fireTransformationsConfigurationModelEvent(SplitConfigurationEventType.RANDOM_SEED_CHANGED, this.getRandomSeed());
        }
    }

    public void setSplitMode(SequencesGroupSplitMode splitMode) {
        if (this.splitMode == null || !this.splitMode.equals((Object)splitMode)) {
            this.splitMode = splitMode;
            this.fireTransformationsConfigurationModelEvent(SplitConfigurationEventType.SPLIT_MODE_CHANGED, (Object)this.getSplitMode());
        }
    }

    public void numFiles(int numFiles) {
        if (this.numFiles != numFiles) {
            this.numFiles = numFiles;
            this.fireTransformationsConfigurationModelEvent(SplitConfigurationEventType.NUMBER_OF_FILES_CHANGED, this.getNumFiles());
        }
    }

    public void setNumSequences(int numSequences) {
        if (this.numSequences != numSequences) {
            this.numSequences = numSequences;
            this.fireTransformationsConfigurationModelEvent(SplitConfigurationEventType.NUMBER_OF_SEQUENCES_CHANGED, (Object)this.getSplitMode());
        }
    }

    public void setIndependentExtractions(boolean independentExtractions) {
        if (this.independentExtractions != independentExtractions) {
            this.independentExtractions = independentExtractions;
            this.fireTransformationsConfigurationModelEvent(SplitConfigurationEventType.INDEPENDENT_EXTRACTIONS_CHANGED, this.isIndependentExtractions());
        }
    }
}

