/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.reverse_complement;

import java.util.LinkedList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.rename.AddStringHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderRenamerTransformation;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.reverse_complement.ReverseComplementTransformationChangeType;
import org.sing_group.seda.transformation.sequence.ReverseComplementSequenceTransformation;
import org.sing_group.seda.transformation.sequencesgroup.ComposedSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

@XmlRootElement
public class ReverseComplementTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private boolean reverse;
    @XmlElement
    private boolean complement;
    @XmlElement
    private AddStringHeaderRenamer headerRenamer;

    public ReverseComplementTransformationProvider() {
        this(true, true);
    }

    public ReverseComplementTransformationProvider(boolean reverse, boolean complement) {
        this.reverse = reverse;
        this.complement = complement;
    }

    @Override
    public Validation validate() {
        LinkedList<String> errors = new LinkedList<String>();
        if (!this.reverse && !this.complement) {
            errors.add("Reverse and complement cannot be both false.");
        }
        if (this.headerRenamer != null) {
            errors.addAll(this.headerRenamer.validate().getValidationErrors());
        }
        return new DefaultValidation(errors);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        LinkedList<SequencesGroupTransformation> sequenceGroupTransformations = new LinkedList<SequencesGroupTransformation>();
        sequenceGroupTransformations.add(new ComposedSequencesGroupTransformation(factory, new ReverseComplementSequenceTransformation(this.reverse, this.complement, factory)));
        if (this.headerRenamer != null) {
            sequenceGroupTransformations.add(new HeaderRenamerTransformation(this.headerRenamer, factory));
        }
        return SequencesGroupDatasetTransformation.concat(new ComposedSequencesGroupDatasetTransformation(factory, SequencesGroupTransformation.concat(sequenceGroupTransformations.toArray(new SequencesGroupTransformation[sequenceGroupTransformations.size()]))));
    }

    public void setReverseSequences(boolean reverse) {
        if (this.reverse != reverse) {
            this.reverse = reverse;
            this.fireTransformationsConfigurationModelEvent(ReverseComplementTransformationChangeType.REVERSE_CHANGED, this.reverse);
        }
    }

    public boolean isReverseSequences() {
        return this.reverse;
    }

    public void setComplementSequences(boolean complement) {
        if (this.complement != complement) {
            this.complement = complement;
            this.fireTransformationsConfigurationModelEvent(ReverseComplementTransformationChangeType.COMPLEMENT_CHANGED, this.complement);
        }
    }

    public boolean isComplementSequences() {
        return this.complement;
    }

    public void setHeaderRenamer(AddStringHeaderRenamer headerRenamer) {
        if (this.headerRenamer == null || !this.headerRenamer.equals(headerRenamer)) {
            this.headerRenamer = headerRenamer;
            this.fireTransformationsConfigurationModelEvent(ReverseComplementTransformationChangeType.HEADER_RENAMED_CHANGED, this.headerRenamer);
        }
    }

    public void clearHeaderRenamer() {
        this.headerRenamer = null;
        this.fireTransformationsConfigurationModelEvent(ReverseComplementTransformationChangeType.HEADER_RENAMED_CHANGED, this.headerRenamer);
    }

    public AddStringHeaderRenamer getHeaderRenamer() {
        return this.headerRenamer;
    }
}

