/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.rename;

import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.IntervalReplaceRenamer;
import org.sing_group.seda.gui.configuration_panel.rename.AbstractRenameHeaderPanel;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderReplaceIntervalSedaPluginInfo;

public class IntervalReplaceRenamePanel
extends AbstractRenameHeaderPanel {
    private static final long serialVersionUID = 1L;
    private JXTextField fromStringTextField;
    private JXTextField toStringTextField;
    private JXTextField replacementTextField;

    public IntervalReplaceRenamePanel() {
        this.init();
    }

    private void init() {
        this.add(new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] toret = new InputParameter[]{this.getFromStringParameter(), this.getToStringParameter(), this.getReplacementStringParameter()};
        return toret;
    }

    private InputParameter getFromStringParameter() {
        this.fromStringTextField = new JXTextField("From");
        this.fromStringTextField.setColumns(10);
        this.fromStringTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("From", this.fromStringTextField, RenameHeaderReplaceIntervalSedaPluginInfo.PARAM_FROM_HELP_GUI);
    }

    private InputParameter getToStringParameter() {
        this.toStringTextField = new JXTextField("Delimiter");
        this.toStringTextField.setColumns(10);
        this.toStringTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("To", this.toStringTextField, RenameHeaderReplaceIntervalSedaPluginInfo.PARAM_TO_DELIMITER_HELP_GUI);
    }

    private InputParameter getReplacementStringParameter() {
        this.replacementTextField = new JXTextField("Replacement");
        this.replacementTextField.setColumns(10);
        this.replacementTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Replacement", this.replacementTextField, RenameHeaderReplaceIntervalSedaPluginInfo.PARAM_INTERVAL_REPLACEMENT_HELP_GUI);
    }

    private String getFromString() {
        return this.fromStringTextField.getText();
    }

    private String getToString() {
        return this.toStringTextField.getText();
    }

    private String getReplacement() {
        return this.replacementTextField.getText();
    }

    @Override
    public boolean isValidConfiguration() {
        return !this.getFromString().isEmpty() && !this.getToString().isEmpty();
    }

    @Override
    public HeaderRenamer getHeaderRenamer(HeaderTarget target) {
        return new IntervalReplaceRenamer(target, this.getFromString(), this.getToString(), this.getReplacement());
    }

    public void setHeaderRenamer(IntervalReplaceRenamer renamer) {
        this.fromStringTextField.setText(renamer.getFrom());
        this.toStringTextField.setText(renamer.getTo());
        this.replacementTextField.setText(renamer.getReplacement());
    }
}

