/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.rename;

import java.awt.event.ItemEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.seda.core.rename.AddStringHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.gui.configuration_panel.rename.AbstractRenameHeaderPanel;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderAddWordSedaPluginInfo;

public class AddStringHeaderRenamePanel
extends AbstractRenameHeaderPanel {
    private static final long serialVersionUID = 1L;
    private final boolean addIndexVisible;
    private JXTextField prefixStringTextField;
    private JXTextField delimiterStringTextField;
    private RadioButtonsPanel<AddStringHeaderRenamer.Position> positionRbtnPanel;
    private JCheckBox addIndexCheckBox;
    private JXTextField indexDelimiterTextField;
    private JIntegerTextField startIndexTextField;
    private List<InputParameter> additionalParameters;

    public AddStringHeaderRenamePanel() {
        this(true, Collections.emptyList());
    }

    public AddStringHeaderRenamePanel(boolean addIndexVisible, List<InputParameter> additionalParameters) {
        this.addIndexVisible = addIndexVisible;
        this.additionalParameters = additionalParameters;
        this.init();
    }

    private void init() {
        this.add(new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> toret = new LinkedList<InputParameter>(this.additionalParameters);
        toret.add(this.getPositionParameter());
        toret.add(this.getPrefixStringParameter());
        toret.add(this.getDelimiterStringParameter());
        if (this.addIndexVisible) {
            toret.add(this.getAddIndexParameter());
            toret.add(this.getIndexDelimiterParameter());
            toret.add(this.getStartIndexParameter());
        }
        return toret.toArray(new InputParameter[toret.size()]);
    }

    private InputParameter getPositionParameter() {
        this.positionRbtnPanel = new RadioButtonsPanel<AddStringHeaderRenamer.Position>(AddStringHeaderRenamer.Position.values(), 1, 2);
        this.positionRbtnPanel.addItemListener(this::positionValueChanged);
        return new InputParameter("Position", this.positionRbtnPanel, RenameHeaderAddWordSedaPluginInfo.PARAM_POSITION_HELP_GUI);
    }

    private void positionValueChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.renameConfigurationChanged();
        }
    }

    private InputParameter getPrefixStringParameter() {
        this.prefixStringTextField = new JXTextField("String");
        this.prefixStringTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("String", this.prefixStringTextField, RenameHeaderAddWordSedaPluginInfo.PARAM_STRING_HELP_GUI);
    }

    private InputParameter getDelimiterStringParameter() {
        this.delimiterStringTextField = new JXTextField("Delimiter");
        this.delimiterStringTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Delimiter", this.delimiterStringTextField, RenameHeaderAddWordSedaPluginInfo.PARAM_DELIMITER_HELP_GUI);
    }

    private InputParameter getAddIndexParameter() {
        this.addIndexCheckBox = new JCheckBox("Add index?");
        this.addIndexCheckBox.addItemListener(this::addIndexCheckBoxItemEvent);
        return new InputParameter("", this.addIndexCheckBox, RenameHeaderAddWordSedaPluginInfo.PARAM_ADD_INDEX_HELP_GUI);
    }

    private InputParameter getIndexDelimiterParameter() {
        this.indexDelimiterTextField = new JXTextField("Index delimiter");
        this.indexDelimiterTextField.setEnabled(false);
        this.indexDelimiterTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Index delimiter", this.indexDelimiterTextField, RenameHeaderAddWordSedaPluginInfo.PARAM_INDEX_DELIMITER_HELP_GUI);
    }

    private InputParameter getStartIndexParameter() {
        this.startIndexTextField = new JIntegerTextField((Integer)1);
        this.startIndexTextField.setEnabled(false);
        this.startIndexTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Start index", this.startIndexTextField, RenameHeaderAddWordSedaPluginInfo.PARAM_START_INDEX_HELP_GUI);
    }

    private void addIndexCheckBoxItemEvent(ItemEvent event) {
        this.renameConfigurationChanged();
        this.indexDelimiterTextField.setEnabled(this.addIndexCheckBox.isSelected());
        this.startIndexTextField.setEnabled(this.addIndexCheckBox.isSelected());
    }

    private String getPrefixString() {
        return this.prefixStringTextField.getText();
    }

    private String getDelimiterString() {
        return this.delimiterStringTextField.getText();
    }

    private boolean isAddIndex() {
        return this.addIndexCheckBox.isSelected();
    }

    private String getIndexDelimiterString() {
        return this.indexDelimiterTextField.getText();
    }

    private int getStartIndex() {
        return this.startIndexTextField.getValue();
    }

    private AddStringHeaderRenamer.Position getPosition() {
        return this.positionRbtnPanel.getSelectedItem().get();
    }

    @Override
    public boolean isValidConfiguration() {
        return this.isAddIndex() || !this.getPrefixString().isEmpty();
    }

    @Override
    public HeaderRenamer getHeaderRenamer(HeaderTarget target) {
        return new AddStringHeaderRenamer(target, this.getPrefixString(), this.getDelimiterString(), this.getPosition(), this.isAddIndex(), this.getIndexDelimiterString(), this.getStartIndex());
    }

    public void setHeaderRenamer(AddStringHeaderRenamer renamer) {
        this.prefixStringTextField.setText(renamer.getString());
        this.delimiterStringTextField.setText(renamer.getDelimiter());
        this.positionRbtnPanel.setSelectedItem(renamer.getPosition());
        this.addIndexCheckBox.setSelected(renamer.isAddIndex());
        this.indexDelimiterTextField.setText(renamer.getIndexDelimiter());
    }
}

