/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.pattern;

import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.datatype.pattern.SequencePatternGroup;
import org.sing_group.seda.gui.configuration_panel.pattern.PatternEditionEvent;
import org.sing_group.seda.gui.configuration_panel.pattern.PatternFilteringConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.pattern.SequencePatternEditorListener;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationPanelPropertyChangeAdapter;
import org.sing_group.seda.transformation.provider.pattern.PatternFilteringTransformationProvider;

public class PatternFilteringPluginPanel
extends CenteredJPanel {
    private static final long serialVersionUID = 1L;
    private PatternFilteringConfigurationPanel transformationPanel;
    private PatternFilteringTransformationProvider transformationProvider = this.buildTransformationProvider();

    public PatternFilteringPluginPanel() {
        this.init();
    }

    protected PatternFilteringTransformationProvider buildTransformationProvider() {
        return new PatternFilteringTransformationProvider();
    }

    private void init() {
        this.add(this.getConfigurationPanel());
    }

    private Component getConfigurationPanel() {
        this.transformationPanel = new PatternFilteringConfigurationPanel();
        this.updateProviderTarget();
        this.addListeners();
        return this.transformationPanel;
    }

    private void addListeners() {
        this.transformationPanel.getPatternsPanel().addSequencePatternEditorListener(new SequencePatternEditorListener(){

            @Override
            public void patternRemoved(ChangeEvent event) {
                PatternFilteringPluginPanel.this.patternsChanged();
            }

            @Override
            public void patternEdited(PatternEditionEvent event) {
                PatternFilteringPluginPanel.this.patternsChanged();
            }

            @Override
            public void patternAdded(ChangeEvent event) {
                PatternFilteringPluginPanel.this.patternsChanged();
            }
        });
        this.transformationPanel.getTranslationPanel().addPropertyChangeListener(new SequenceTranslationPanelPropertyChangeAdapter(){

            @Override
            protected void translationPropertyChanged() {
                PatternFilteringPluginPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void joinFramesPropertyChanged() {
                PatternFilteringPluginPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void framesPropertyChanged() {
                PatternFilteringPluginPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void codonTablePropertyChanged() {
                PatternFilteringPluginPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void reverseSequencesPropertyChanged() {
                PatternFilteringPluginPanel.this.translationConfigurationChanged();
            }
        });
        this.transformationPanel.getSequenceTargetPanel().addItemListener(this::sequenceTargetChanged);
    }

    public void sequenceTargetChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateProviderTarget();
        }
    }

    private void updateProviderTarget() {
        this.transformationProvider.setTarget(this.transformationPanel.getSequenceTargetPanel().getSelectedItem().get());
    }

    private void translationConfigurationChanged() {
        if (this.transformationPanel.getTranslationPanel().isTranslationSelected() && this.transformationPanel.getTranslationPanel().isValidUserSelection()) {
            this.transformationProvider.setTranslationConfiguration(this.transformationPanel.getTranslationPanel().getSequenceTranslationConfiguration());
        } else {
            this.transformationProvider.clearTranslationConfiguration();
        }
    }

    private void patternsChanged() {
        if (this.transformationPanel.getPatternsPanel().isValidUserSelection()) {
            this.transformationProvider.setPattern(this.transformationPanel.getPatternsPanel().getSequencePatternGroup());
        } else {
            this.transformationProvider.clearPattern();
        }
    }

    public PatternFilteringTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(PatternFilteringTransformationProvider transformationProvider) {
        this.transformationPanel.setTarget(transformationProvider.getTarget());
        this.transformationPanel.setTranslationConfiguration(transformationProvider.getTranslationConfiguration());
        this.transformationPanel.setEvaluableSequencePattern((SequencePatternGroup)transformationProvider.getPattern());
    }
}

