/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.isoforms;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.seda.core.operations.DefaultSequenceIsoformSelector;
import org.sing_group.seda.plugin.core.info.plugin.RemoveIsoformsSedaPluginInfo;

public class DefaultSequenceIsoformConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String DESCRIPTION_REFERENCE_SIZE = RemoveIsoformsSedaPluginInfo.PARAM_REFERENCE_SIZE_HELP_GUI;
    public static final String DESCRIPTION_TIE_BREAK = RemoveIsoformsSedaPluginInfo.PARAM_TIE_BREAK_HELP_GUI;
    public static final int DEFAULT_REFERENCE_SIZE = 250;
    public static final DefaultSequenceIsoformSelector.TieBreakOption DEFAULT_TIE_BREAK_OPTION = RemoveIsoformsSedaPluginInfo.DEFAULT_REMOVE_ISOFORM_TIE_BREAK_OPTION;
    public static final String PROPERTY_REFERENCE_SIZE = "property.reference.size";
    public static final String PROPERTY_TIE_BREAK_OPTION = "property.tie.break.option";
    public static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("property.tie.break.option", "property.reference.size"));
    private JIntegerTextField referenceSizeTf;
    private RadioButtonsPanel<DefaultSequenceIsoformSelector.TieBreakOption> tieBreakOptionRbtn;
    private int oldReferenceSizeValue = 250;
    private DefaultSequenceIsoformSelector.TieBreakOption oldTieBreakOption = DEFAULT_TIE_BREAK_OPTION;

    public DefaultSequenceIsoformConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(new InputParametersPanel(this.getInputParameters()));
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getReferenceSizeParameter());
        parameters.add(this.getTieBreakOptionParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getReferenceSizeParameter() {
        this.referenceSizeTf = new JIntegerTextField((Integer)250);
        this.referenceSizeTf.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultSequenceIsoformConfigurationPanel.this.referenceSizeChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultSequenceIsoformConfigurationPanel.this.referenceSizeChanged();
            }
        });
        return new InputParameter("Reference size: ", this.referenceSizeTf, DESCRIPTION_REFERENCE_SIZE);
    }

    private void referenceSizeChanged() {
        int newValue = this.getReferenceSizeValue();
        this.firePropertyChange(PROPERTY_REFERENCE_SIZE, this.oldReferenceSizeValue, newValue);
        this.oldReferenceSizeValue = newValue;
    }

    public int getReferenceSizeValue() {
        return this.referenceSizeTf.getValue();
    }

    private InputParameter getTieBreakOptionParameter() {
        this.tieBreakOptionRbtn = new RadioButtonsPanel<DefaultSequenceIsoformSelector.TieBreakOption>(DefaultSequenceIsoformSelector.TieBreakOption.values(), 1, DefaultSequenceIsoformSelector.TieBreakOption.values().length);
        this.tieBreakOptionRbtn.setSelectedItem(DEFAULT_TIE_BREAK_OPTION);
        this.tieBreakOptionRbtn.addItemListener(this::tieBreakOptionChanged);
        return new InputParameter("Tie break mode: ", this.tieBreakOptionRbtn, DESCRIPTION_TIE_BREAK);
    }

    private void tieBreakOptionChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            DefaultSequenceIsoformSelector.TieBreakOption newValue = this.getTieBreakOption();
            this.firePropertyChange(PROPERTY_TIE_BREAK_OPTION, (Object)this.oldTieBreakOption, (Object)newValue);
            this.oldTieBreakOption = newValue;
        }
    }

    private DefaultSequenceIsoformSelector.TieBreakOption getTieBreakOption() {
        return this.tieBreakOptionRbtn.getSelectedItem().get();
    }

    public DefaultSequenceIsoformSelector getSelector() {
        return new DefaultSequenceIsoformSelector(this.getReferenceSizeValue(), this.getTieBreakOption());
    }

    public void setSelector(DefaultSequenceIsoformSelector selector) {
        this.referenceSizeTf.setValue(selector.getReferenceSize());
        this.tieBreakOptionRbtn.setSelectedItem(selector.getTieBreak());
    }
}

