/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationPanel;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationPanelPropertyChangeAdapter;
import org.sing_group.seda.plugin.core.info.plugin.RemoveRedundantSequencesSedaPluginInfo;
import org.sing_group.seda.transformation.provider.redundant.RemoveRedundantSequencesTransformationProvider;
import org.sing_group.seda.transformation.sequencesgroup.RemoveRedundantSequencesTransformation;

public class RemoveRedundantSequencesConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TRANSLATION_LABEL = "Convert to amino acid sequences before sequence comparison";
    private static final String TRANSLATION_INFO = RemoveRedundantSequencesSedaPluginInfo.PARAM_CONVERT_AMINO_ACID_HELP_GUI;
    private RemoveRedundantSequencesTransformationProvider transformationProvider;
    private JCheckBox removeContainedSequencesCb;
    private JCheckBox mergeHeadersCb;
    private JFileChooserPanel mergedHeadersFileChooser;
    private SequenceTranslationPanel sequenceTranslationPanel;

    public RemoveRedundantSequencesConfigurationPanel() {
        this.init();
        this.transformationProvider = new RemoveRedundantSequencesTransformationProvider();
        this.notifyConfigurationChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.getParametersPanel(), "Center");
        mainPanel.add((Component)this.getTranslationPanel(), "South");
        return new CenteredJPanel(mainPanel);
    }

    private JPanel getParametersPanel() {
        return new InputParametersPanel(this.getInputParameters());
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getRemoveContainedSequencesParameter());
        parameters.add(this.getMergeHeadersParameter());
        parameters.add(this.getSaveMergeHeadersFileParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getRemoveContainedSequencesParameter() {
        this.removeContainedSequencesCb = new JCheckBox("Remove also subsequences", true);
        this.removeContainedSequencesCb.addItemListener(this::configurationChanged);
        return new InputParameter("", this.removeContainedSequencesCb, RemoveRedundantSequencesSedaPluginInfo.PARAM_REMOVE_SUBSEQUENCE_HELP_GUI);
    }

    private InputParameter getMergeHeadersParameter() {
        this.mergeHeadersCb = new JCheckBox("Merge headers", true);
        this.mergeHeadersCb.addItemListener(this::configurationChanged);
        return new InputParameter("", this.mergeHeadersCb, RemoveRedundantSequencesSedaPluginInfo.PARAM_MERGE_HEADERS_HELP_GUI);
    }

    private InputParameter getSaveMergeHeadersFileParameter() {
        this.mergedHeadersFileChooser = JFileChooserPanelBuilder.createSaveJFileChooserPanel().withLabel("Merged headers reports directory:").withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.DIRECTORIES).build();
        this.mergedHeadersFileChooser.addFileChooserListener(this::selectedFileChanged);
        return new InputParameter("", this.mergedHeadersFileChooser, RemoveRedundantSequencesSedaPluginInfo.PARAM_SAVE_MERGED_HEADERS_HELP_GUI);
    }

    private void configurationChanged(ItemEvent event) {
        this.notifyConfigurationChanged();
    }

    private void selectedFileChanged(ChangeEvent event) {
        this.notifyConfigurationChanged();
    }

    private void notifyConfigurationChanged() {
        this.transformationProvider.setConfiguration(this.getConfiguration());
    }

    public SequenceTranslationPanel getTranslationPanel() {
        if (this.sequenceTranslationPanel == null) {
            this.sequenceTranslationPanel = new SequenceTranslationPanel(TRANSLATION_LABEL, TRANSLATION_INFO, false);
            this.sequenceTranslationPanel.addPropertyChangeListener(new SequenceTranslationPanelPropertyChangeAdapter(){

                @Override
                protected void translationPropertyChanged() {
                    RemoveRedundantSequencesConfigurationPanel.this.sequenceTranslationConfigurationChanged();
                }

                @Override
                protected void joinFramesPropertyChanged() {
                    RemoveRedundantSequencesConfigurationPanel.this.sequenceTranslationConfigurationChanged();
                }

                @Override
                protected void framesPropertyChanged() {
                    RemoveRedundantSequencesConfigurationPanel.this.sequenceTranslationConfigurationChanged();
                }

                @Override
                protected void codonTablePropertyChanged() {
                    RemoveRedundantSequencesConfigurationPanel.this.sequenceTranslationConfigurationChanged();
                }

                @Override
                protected void reverseSequencesPropertyChanged() {
                    RemoveRedundantSequencesConfigurationPanel.this.sequenceTranslationConfigurationChanged();
                }
            });
        }
        return this.sequenceTranslationPanel;
    }

    private void sequenceTranslationConfigurationChanged() {
        this.notifyConfigurationChanged();
    }

    public RemoveRedundantSequencesTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration getConfiguration() {
        SequenceTranslationConfiguration translationConfiguration = this.sequenceTranslationPanel.getSequenceTranslationConfiguration();
        File saveMergedHeadersFile = this.getSaveMergedHeadersFile();
        if (saveMergedHeadersFile != null) {
            if (this.sequenceTranslationPanel.isTranslationSelected()) {
                return new RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration(this.isRemoveContainedSequences(), this.isMergeHeaders(), saveMergedHeadersFile, translationConfiguration);
            }
            return new RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration(this.isRemoveContainedSequences(), this.isMergeHeaders(), saveMergedHeadersFile);
        }
        if (this.sequenceTranslationPanel.isTranslationSelected()) {
            return new RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration(this.isRemoveContainedSequences(), this.isMergeHeaders(), translationConfiguration);
        }
        return new RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration(this.isRemoveContainedSequences(), this.isMergeHeaders());
    }

    private RemoveRedundantSequencesTransformation.Mode isRemoveContainedSequences() {
        if (this.removeContainedSequencesCb.isSelected()) {
            return RemoveRedundantSequencesTransformation.Mode.CONTAINED_SEQUENCES;
        }
        return RemoveRedundantSequencesTransformation.Mode.EXACT_DUPLICATES;
    }

    private boolean isMergeHeaders() {
        return this.mergeHeadersCb.isSelected();
    }

    private File getSaveMergedHeadersFile() {
        return this.mergedHeadersFileChooser.getSelectedFile();
    }

    public void setTransformationProvider(RemoveRedundantSequencesTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        RemoveRedundantSequencesTransformation.RemoveRedundantSequencesTransformationConfiguration configuration = this.transformationProvider.getConfiguration();
        this.removeContainedSequencesCb.setSelected(configuration.getMode().equals((Object)RemoveRedundantSequencesTransformation.Mode.CONTAINED_SEQUENCES));
        this.mergeHeadersCb.setSelected(configuration.isMergeHeaders());
        Optional<File> mergedSequencesDirectory = configuration.getMergedSequencesListDirectory();
        if (mergedSequencesDirectory.isPresent()) {
            this.mergedHeadersFileChooser.setSelectedFile(mergedSequencesDirectory.get());
        } else {
            this.mergedHeadersFileChooser.clearSelectedFile();
        }
        this.sequenceTranslationPanel.setSequenceTranslationConfiguration(configuration.getSequenceTranslationConfiguration());
    }
}

