/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype.statistics;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.statistics.SequencesGroupStatistics;

public class SequencesGroupDatasetStatistics {
    private List<SequencesGroupStatistics> statistics;

    public SequencesGroupDatasetStatistics(Map<Path, SequencesGroup> sequenceGroupMap) {
        this.statistics = sequenceGroupMap.entrySet().stream().map(entry -> new SequencesGroupStatistics((Path)entry.getKey(), (SequencesGroup)entry.getValue())).collect(Collectors.toList());
    }

    public List<SequencesGroupStatistics> getStatistics() {
        return this.statistics;
    }

    public long getTotalFileSize() {
        return this.statistics.stream().mapToLong(SequencesGroupStatistics::getFileSize).sum();
    }

    public int size() {
        return this.statistics.size();
    }

    public SequencesGroupStatistics get(int index) {
        return this.statistics.get(index);
    }

    public int getTotalSecuencesCount() {
        return this.statistics.stream().mapToInt(SequencesGroupStatistics::getSequenceCount).sum();
    }
}

