/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.operations;

import java.util.HashSet;
import java.util.LinkedList;
import org.sing_group.seda.core.operations.SequenceIsoformTester;
import org.sing_group.seda.core.operations.SequencesGroupIsoformTesterResult;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;

public class SequencesGroupIsoformTester {
    private SequencesGroup sequencesGroup;

    public SequencesGroupIsoformTester(SequencesGroup sequencesGroup) {
        this.sequencesGroup = sequencesGroup;
    }

    public SequencesGroupIsoformTesterResult test(int wordLength) {
        HashSet<Sequence> toSkip = new HashSet<Sequence>();
        SequencesGroupIsoformTesterResult result = new SequencesGroupIsoformTesterResult();
        for (int i = 0; i < this.sequencesGroup.getSequenceCount(); ++i) {
            Sequence a = this.sequencesGroup.getSequence(i);
            if (toSkip.contains(a)) continue;
            LinkedList<Sequence> currentIsoformsList = new LinkedList<Sequence>();
            currentIsoformsList.add(a);
            for (int j = i + 1; j < this.sequencesGroup.getSequenceCount(); ++j) {
                boolean isoforms;
                Sequence b = this.sequencesGroup.getSequence(j);
                if (toSkip.contains(b) || !(isoforms = new SequenceIsoformTester(a, b).test(wordLength))) continue;
                currentIsoformsList.add(b);
                toSkip.add(b);
            }
            result.addIsoformsList(currentIsoformsList);
        }
        return result;
    }
}

