/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.parameters;

import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.ncbi.codes.NcbiCodonTables;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.plugin.core.info.common.SequenceTranslationInfo;

public class SequenceTranslationCliParameters {
    public static final IntegerDefaultValuedStringConstructedOption OPTION_FRAME = new IntegerDefaultValuedStringConstructedOption("frame", "f", "Translate sequences starting at a fixed frame.", 1);
    public static final FlagOption OPTION_ALL_FRAMES = new FlagOption("all-frames", "af", "Translate sequences using frames 1, 2 and 3.");
    public static final FlagOption OPTION_JOIN_FRAMES = new FlagOption("join-frames", "jf", "When frames 1, 2 and 3 are considered, this option allows indicating whether translated frames must be considered together or separately.");
    public static final FlagOption OPTION_REVERSE_COMPLEMENT = new FlagOption("reverse-complement", "rc", "Calculate the reverse complement of sequences before translation.");
    public static final IntegerDefaultValuedStringConstructedOption OPTION_CODON_TABLE = new IntegerDefaultValuedStringConstructedOption("codon-table", "ct", SequenceTranslationInfo.PARAM_CODON_TABLE_HELP, 1);
    public static final FileOption OPTION_CODON_TABLE_CUSTOM = new FileOption("codon-table-custom", "ctc", "This option allows using a custom codon conversion table. If not selected, the prefedined codon table selected is used. The custom codon table must be a text file with the following format:\n\tTTT=T\n\tCTT=C\n\tGCA=A", true, true);
    private final boolean checkAminoAcidOption;
    private final boolean checkJoinFramesOption;
    private String convertAminoAcidHelp;
    private FlagOption optionConvertAminoAcid;

    public SequenceTranslationCliParameters(boolean checkAminoAcidOption, boolean checkJoinFramesOption, String convertAminoAcidHelp) {
        this.checkAminoAcidOption = checkAminoAcidOption;
        this.checkJoinFramesOption = checkJoinFramesOption;
        this.convertAminoAcidHelp = convertAminoAcidHelp;
    }

    public List<Option<?>> getOptionList() {
        ArrayList options = new ArrayList();
        if (this.checkAminoAcidOption) {
            this.optionConvertAminoAcid = new FlagOption("convert-amino-acid", "caa", this.convertAminoAcidHelp);
            options.add(this.optionConvertAminoAcid);
        }
        options.add(OPTION_FRAME);
        options.add(OPTION_ALL_FRAMES);
        if (this.checkJoinFramesOption) {
            options.add(OPTION_JOIN_FRAMES);
        }
        options.add(OPTION_REVERSE_COMPLEMENT);
        options.add(OPTION_CODON_TABLE);
        options.add(OPTION_CODON_TABLE_CUSTOM);
        return options;
    }

    public boolean hasConvertAminoAcid(Parameters parameters) {
        return parameters.hasOption(this.optionConvertAminoAcid);
    }

    public SequenceTranslationConfiguration getSequenceTranslationConfiguration(Parameters parameters) throws IllegalArgumentException {
        if (this.checkAminoAcidOption && !this.hasConvertAminoAcid(parameters)) {
            throw new IllegalArgumentException("Missing " + SedaCommand.formatParam(this.optionConvertAminoAcid) + " option");
        }
        Map<String, String> codonTable = Collections.emptyMap();
        if (parameters.hasOption(OPTION_CODON_TABLE_CUSTOM)) {
            codonTable = this.loadCustomMap(parameters.getSingleValue(OPTION_CODON_TABLE_CUSTOM));
        } else {
            NcbiCodonTables ncbiCodonTables = new NcbiCodonTables();
            codonTable = ncbiCodonTables.getCodonTable(parameters.getSingleValue(OPTION_CODON_TABLE));
        }
        boolean isReverseComplement = parameters.hasFlag(OPTION_REVERSE_COMPLEMENT);
        boolean isJoinFrames = false;
        int[] frames = new int[]{parameters.getSingleValue(OPTION_FRAME)};
        if (parameters.hasFlag(OPTION_ALL_FRAMES)) {
            frames = new int[]{1, 2, 3};
            if (this.checkJoinFramesOption) {
                isJoinFrames = parameters.hasFlag(OPTION_JOIN_FRAMES);
            }
        }
        return new SequenceTranslationConfiguration(codonTable, isReverseComplement, isJoinFrames, frames);
    }

    private Map<String, String> loadCustomMap(File file) throws IllegalArgumentException {
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Error processing custom codon file, check if the file exists");
        }
        Properties properties = new Properties();
        try {
            properties.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading custom codon file. Wrong format", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error processing custom codon file, check if the file exists", e);
        }
        HashMap<String, String> customCodonTable = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            customCodonTable.put(name, properties.getProperty(name));
        }
        return customCodonTable;
    }
}

