/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.command.RenameHeaderCommand;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.WordReplaceRenamer;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.rename.RenameHeaderTransformationProvider;

public class RenameHeaderReplaceWordCommand
extends RenameHeaderCommand {
    public static final StringOption OPTION_TARGET_WORDS = new StringOption("target-word", "tw", "The target word.", true, true, true);
    public static final FlagOption OPTION_REGEX = new FlagOption("regex", "r", "Whether targets must be applied as regex or not.");
    public static final DefaultValuedStringOption OPTION_REPLACEMENT = new DefaultValuedStringOption("replacement", "rp", "The replacement.", "");

    @Override
    public String getName() {
        return "rename-header-replace-word";
    }

    @Override
    public String getDescriptiveName() {
        return "Rename header (Replace Word)";
    }

    @Override
    public String getDescription() {
        return "Modify sequence headers by replacing information (target words).";
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.addAll(super.createSedaOptions());
        options.add(OPTION_TARGET_WORDS);
        options.add(OPTION_REGEX);
        options.add(OPTION_REPLACEMENT);
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        RenameHeaderTransformationProvider provider = new RenameHeaderTransformationProvider();
        RenameHeaderReplaceWordCommand.checkMandatoryOption(parameters, OPTION_TARGET_WORDS);
        List<String> targetWordsList = parameters.getAllValues(OPTION_TARGET_WORDS);
        boolean isRegex = parameters.hasFlag(OPTION_REGEX);
        String replacement = parameters.getSingleValue(OPTION_REPLACEMENT);
        HeaderTarget headerTarget = this.getHeaderTarget(parameters);
        provider.setHeaderRenamer(new WordReplaceRenamer(headerTarget, replacement, isRegex, targetWordsList));
        return provider;
    }
}

