/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.RegexHeaderMatcherCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.RegexSplitSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.split.regex.RegexSplitConfigurationTransformationProvider;

public class RegexSplitCommand
extends SedaCommand {
    public static final FileOption OPTION_FILES_DIRECTORY = new FileOption("files-directory", "fd", "Whether the groups created for each file should be saved into a TXT file or not. This allows an easy identification of the sequence groups that have been created. If you do not want to save them, leave this file empty. Otherwise, choose the directory where such files should be created.", true, true);

    @Override
    public String getName() {
        return "split-regex";
    }

    @Override
    public String getDescriptiveName() {
        return "Regular Expression Split";
    }

    @Override
    public String getDescription() {
        return "Split each input FASTA file based on regular expression patterns.";
    }

    @Override
    protected String getSedaGroup() {
        return RegexSplitSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList optionList = new ArrayList();
        optionList.add(OPTION_FILES_DIRECTORY);
        optionList.addAll(RegexHeaderMatcherCliParameters.getOptionList());
        return optionList;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        RegexSplitConfigurationTransformationProvider provider = new RegexSplitConfigurationTransformationProvider();
        try {
            provider.setHeaderMatcher(RegexHeaderMatcherCliParameters.getRegexHeaderMatcher(parameters));
        }
        catch (IllegalArgumentException e) {
            RegexSplitCommand.formattedValidationError(e.getMessage());
        }
        if (parameters.hasOption(OPTION_FILES_DIRECTORY)) {
            File fileDirectory = parameters.getSingleValue(OPTION_FILES_DIRECTORY);
            if (!fileDirectory.isDirectory()) {
                RegexSplitCommand.invalidOptionValue(OPTION_FILES_DIRECTORY, "The specified path is not a directory");
            }
            provider.setSaveGroupNamesDirectory(fileDirectory);
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, RegexSplitConfigurationTransformationProvider.class);
    }
}

