/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.ncbi.NcbiTaxonomyFields;
import org.sing_group.seda.plugin.core.info.plugin.NcbiRenameSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.dataset.MapRenameSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.ncbi.NcbiRenameTransformationProvider;

public class NcbiRenameCommand
extends SedaCommand {
    public static final DefaultValuedStringOption OPTION_FILE_POSITION = new DefaultValuedStringOption("file-position", "fp", NcbiRenameSedaPluginInfo.PARAM_FILE_POSITION_HELP, MapRenameSequencesGroupDatasetTransformation.RenameMode.PREFIX.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_FILE_DELIMITER = new DefaultValuedStringOption("file-delimiter", "fd", "The delimiter for the substitution (only applicable when prefix or suffix modes are used).", "_");
    public static final DefaultValuedStringOption OPTION_HEADER_POSITION = new DefaultValuedStringOption("header-position", "hp", NcbiRenameSedaPluginInfo.PARAM_HEADER_POSITION_HELP, MapRenameSequencesGroupDatasetTransformation.RenameMode.PREFIX.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_HEADER_DELIMITER = new DefaultValuedStringOption("header-delimiter", "hd", "The delimiter for the substitution.", "_");
    public static final FlagOption OPTION_HEADER_INDEX = new FlagOption("add-index", "i", "Whether an index must be added or not.");
    public static final DefaultValuedStringOption OPTION_HEADER_INDEX_DELIMITER = new DefaultValuedStringOption("delimiter-index", "di", "The delimiter for the index.", "_");
    public static final FlagOption OPTION_CONFIG_REPLACE_BLANK_SPACES = new FlagOption("replace-blank-space", "rbs", "Whether blank spaces must be replaced or not.");
    public static final FlagOption OPTION_CONFIG_REPLACE_SPECIAL_CHARACTERS = new FlagOption("replace-special-characters", "rsc", NcbiRenameSedaPluginInfo.PARAM_CONFIG_REPLACE_SPECIAL_CHARACTERS_HELP);
    public static final DefaultValuedStringOption OPTION_CONFIG_REPLACEMENT = new DefaultValuedStringOption("replacement", "r", "The replacement string for those special characters.", "_");
    public static final FileOption OPTION_CONFIG_REPLACEMENTS_MAP_FILE = new FileOption("map-file", "mp", "The file to save the replacements map.", true, true);
    public static final DefaultValuedStringOption OPTION_NCBI_DELIMITER = new DefaultValuedStringOption("ncbi-delimiter", "nd", "The fields delimiter.", "_");
    public static final StringOption OPTION_NCBI_FIELDS = new StringOption("include-taxonomy-field", "itf", NcbiRenameSedaPluginInfo.PARAM_NCBI_FIELDS_HELP, true, true, true);

    @Override
    public String getName() {
        return "rename-ncbi";
    }

    @Override
    public String getDescriptiveName() {
        return "NCBI Rename";
    }

    @Override
    public String getDescription() {
        return "Modify sequence headers and/or file names replacing NCBI accession numbers with organism names and additional information from the NCBI Taxonomy Browser.";
    }

    @Override
    protected String getSedaGroup() {
        return NcbiRenameSedaPluginInfo.GROUP;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        NcbiRenameTransformationProvider provider = new NcbiRenameTransformationProvider();
        provider = this.setFileNameParams(provider, parameters);
        provider = this.setSequenceHeadersParams(provider, parameters);
        provider = this.setConfigurationParams(provider, parameters);
        provider = this.setNcbiTaxonomyParams(provider, parameters);
        return provider;
    }

    private NcbiRenameTransformationProvider setFileNameParams(NcbiRenameTransformationProvider provider, Parameters parameters) {
        MapRenameSequencesGroupDatasetTransformation.RenameMode filePosition = null;
        try {
            filePosition = MapRenameSequencesGroupDatasetTransformation.RenameMode.valueOf(parameters.getSingleValueString(OPTION_FILE_POSITION).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            NcbiRenameCommand.invalidEnumValue(OPTION_FILE_POSITION);
        }
        provider.setFilePosition(filePosition);
        provider.setFileDelimiter(parameters.getSingleValueString(OPTION_FILE_DELIMITER));
        return provider;
    }

    private NcbiRenameTransformationProvider setSequenceHeadersParams(NcbiRenameTransformationProvider provider, Parameters parameters) {
        MapRenameSequencesGroupDatasetTransformation.RenameMode sequencePosition = null;
        try {
            sequencePosition = MapRenameSequencesGroupDatasetTransformation.RenameMode.valueOf(parameters.getSingleValueString(OPTION_HEADER_POSITION).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            NcbiRenameCommand.invalidEnumValue(OPTION_HEADER_POSITION);
        }
        provider.setSequencePosition(sequencePosition);
        provider.setSequenceDelimiter(parameters.getSingleValueString(OPTION_HEADER_DELIMITER));
        provider.setSequenceAddIndex(parameters.hasFlag(OPTION_HEADER_INDEX));
        provider.setSequenceIndexDelimiter(parameters.getSingleValueString(OPTION_HEADER_INDEX_DELIMITER));
        return provider;
    }

    private NcbiRenameTransformationProvider setConfigurationParams(NcbiRenameTransformationProvider provider, Parameters parameters) {
        provider.setReplaceBlankSpaces(parameters.hasFlag(OPTION_CONFIG_REPLACE_BLANK_SPACES));
        provider.setReplaceSpecialCharacters(parameters.hasFlag(OPTION_CONFIG_REPLACE_SPECIAL_CHARACTERS));
        provider.setReplacementString(parameters.getSingleValueString(OPTION_CONFIG_REPLACEMENT));
        boolean hasMapFile = false;
        if (parameters.hasOption(OPTION_CONFIG_REPLACEMENTS_MAP_FILE)) {
            hasMapFile = true;
            File mapFile = parameters.getSingleValue(OPTION_CONFIG_REPLACEMENTS_MAP_FILE);
            if (!mapFile.getParentFile().isDirectory()) {
                NcbiRenameCommand.formattedValidationError("The specified replacements file path does not exist");
            }
            if (!mapFile.getParentFile().canWrite()) {
                NcbiRenameCommand.formattedValidationError("The directory containing the replacements file is not writable.");
            }
            provider.setReplacementsMapFile(mapFile);
        }
        provider.setSaveReplacementsMap(hasMapFile);
        return provider;
    }

    private NcbiRenameTransformationProvider setNcbiTaxonomyParams(NcbiRenameTransformationProvider provider, Parameters parameters) {
        provider.setNcbiTaxonomyDelimiter(parameters.getSingleValueString(OPTION_NCBI_DELIMITER));
        List<NcbiTaxonomyFields> fieldsList = new ArrayList<NcbiTaxonomyFields>();
        if (parameters.hasOption(OPTION_NCBI_FIELDS)) {
            fieldsList = parameters.getAllValues(OPTION_NCBI_FIELDS).stream().map(String::toUpperCase).map(field -> {
                NcbiTaxonomyFields ncbiTaxonomyFields = null;
                try {
                    ncbiTaxonomyFields = NcbiTaxonomyFields.valueOf(field);
                }
                catch (IllegalArgumentException e) {
                    NcbiRenameCommand.invalidEnumValue(OPTION_NCBI_FIELDS);
                }
                return ncbiTaxonomyFields;
            }).collect(Collectors.toList());
        }
        provider.setNcbiTaxonomyFields(fieldsList);
        return provider;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_FILE_POSITION, OPTION_FILE_DELIMITER, OPTION_HEADER_POSITION, OPTION_HEADER_DELIMITER, OPTION_HEADER_INDEX, OPTION_HEADER_INDEX_DELIMITER, OPTION_CONFIG_REPLACE_BLANK_SPACES, OPTION_CONFIG_REPLACE_SPECIAL_CHARACTERS, OPTION_CONFIG_REPLACEMENT, OPTION_CONFIG_REPLACEMENTS_MAP_FILE, OPTION_NCBI_DELIMITER, OPTION_NCBI_FIELDS);
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, NcbiRenameTransformationProvider.class);
    }
}

