/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.GrowSequencesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.grow.GrowSequencesTransformationProvider;

public class GrowSequencesCommand
extends SedaCommand {
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MINIMUM_OVERLAPPING = new IntegerDefaultValuedStringConstructedOption("minimum-overlapping", "mo", "The minimum overlapping to merge two sequences.", 500);

    @Override
    public String getName() {
        return "grow";
    }

    @Override
    public String getDescriptiveName() {
        return "Grow sequences";
    }

    @Override
    public String getDescription() {
        return "Grow sequences by merging those that show an overlap longer than that specified.";
    }

    @Override
    protected String getSedaGroup() {
        return GrowSequencesSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_MINIMUM_OVERLAPPING);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        GrowSequencesTransformationProvider provider = new GrowSequencesTransformationProvider();
        provider.setMinimumOverlapping(parameters.getSingleValue(OPTION_MINIMUM_OVERLAPPING));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, GrowSequencesTransformationProvider.class);
    }
}

