/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli;

import es.uvigo.ei.sing.yacli.CLIApplication;
import es.uvigo.ei.sing.yacli.command.Command;
import es.uvigo.ei.sing.yacli.command.CommandPrinterConfiguration;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.plugin.SedaPluginManager;
import org.sing_group.seda.plugin.spi.SedaCliPlugin;
import org.sing_group.seda.plugin.spi.SedaPluginFactory;
import org.sing_group.seda.util.SedaApplicationInfo;

public class SedaCliApplication
extends CLIApplication {
    @Override
    protected List<Command> buildCommands() {
        return new SedaPluginManager().getFactories().flatMap(SedaPluginFactory::getCliPlugins).map(SedaCliPlugin::getCommand).collect(Collectors.toList());
    }

    @Override
    protected String getApplicationName() {
        return SedaApplicationInfo.getName();
    }

    @Override
    protected String getApplicationCommand() {
        return "seda";
    }

    @Override
    protected String getApplicationVersion() {
        return SedaApplicationInfo.getVersion();
    }

    @Override
    protected String getDescription() {
        return "seda is a CLI application for running all SEDA (SEquence DAtaset builder) operations for processing FASTA files containing DNA and protein sequences. The SEDA CLI has over 30 commands, which are listed below along with their usage and arguments.";
    }

    public static void main(String[] args) {
        new SedaCliApplication().run(args);
    }

    @Override
    protected CommandPrinterConfiguration getCommandPrinterConfiguration() {
        return new CommandPrinterConfiguration(true, " This parameter can be specified multiple times.", "Command options:", 120);
    }

    @Override
    protected void printCommandsInHelp(PrintStream out, List<Command> commands) {
        out.println();
        HashMap commandsMap = new HashMap();
        for (Command command : commands) {
            if (!(command instanceof SedaCommand)) continue;
            String group = ((SedaCommand)command).getSedaGroup();
            commandsMap.putIfAbsent(group, new ArrayList());
            ((List)commandsMap.get(group)).add(command);
        }
        LinkedList groups = new LinkedList(commandsMap.keySet());
        Collections.sort(groups, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String groupName : groups) {
            out.println(groupName + " commands:");
            List operations = (List)commandsMap.get(groupName);
            Collections.sort(operations, new Comparator<Command>(){

                @Override
                public int compare(Command o1, Command o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (Command command : operations) {
                this.printCommandInHelp(out, command);
            }
            out.println();
        }
    }
}

