/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.ui;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;

public class UIUtils {
    public static void applyRecursive(JComponent aComponent, Consumer<JComponent> consumer) {
        consumer.accept(aComponent);
        UIUtils.getJComponents(aComponent).forEach(c2 -> UIUtils.applyRecursive(c2, consumer));
    }

    public static void setBackgroundColorRecursive(JComponent aComponent, Color bg) {
        UIUtils.applyRecursive(aComponent, c -> c.setBackground(bg));
    }

    public static void setOpaqueRecursive(JComponent aComponent, boolean opaque) {
        UIUtils.applyRecursive(aComponent, c -> c.setOpaque(opaque));
    }

    public static List<JComponent> getJComponents(JComponent aComponent) {
        return Stream.of(aComponent.getComponents()).filter(c -> c instanceof JComponent).map(c -> (JComponent)c).collect(Collectors.toList());
    }
}

