/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemListener;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.sing_group.gc4s.event.TextFieldSelectionFocusListener;
import org.sing_group.gc4s.input.csv.CsvFormat;
import org.sing_group.gc4s.input.csv.event.CsvListener;
import org.sing_group.gc4s.input.text.JLimitedTextField;
import org.sing_group.gc4s.ui.icons.Icons;

public class CsvPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final TextFieldSelectionFocusListener FOCUS_LISTENER = new TextFieldSelectionFocusListener();
    private static final CsvFormat.FileFormat DEFAULT_FILE_FORMAT = CsvFormat.FileFormat.LIBRE_OFFICE;
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
    private JComboBox<CsvFormat.FileFormat> fileFormatCB;
    private JXTaskPane customFormatOptionsTaskPane;
    private JCheckBox quoteFields;
    private JRadioButton rbtnSepTab;
    private AbstractButton rbtnSepCustom;
    private JTextComponent txtFieldCustomColumnSeparator;
    private AbstractButton rbtnDecimalSepPoint;
    private AbstractButton rbtnDecimalSepComma;
    private AbstractButton rbtnDecimalSepCustom;
    private JTextComponent txtFieldCustomDecimalPoint;
    private JRadioButton rbtnLineSepWindows;
    private JRadioButton rbtnLineSepLinux;
    private AbstractButton rbtnLineSepMacOS;
    private boolean updateWithoutEvents = false;

    public CsvPanel() {
        this.initComponent();
    }

    private void initComponent() {
        UIManager.put("TaskPane.animate", Boolean.FALSE);
        this.setLayout(new BorderLayout());
        this.add(this.getNorthPane(), "North");
        this.add(this.getCenterPane(), "Center");
    }

    private Component getNorthPane() {
        JPanel northPane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(northPane);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        northPane.setLayout(groupLayout);
        JLabel lblFormat = new JLabel("Format");
        JLabel lblFormatHelp = new JLabel(Icons.ICON_INFO_2_16);
        lblFormatHelp.setToolTipText("The file format");
        this.fileFormatCB = new JComboBox();
        this.fileFormatCB.setModel(new DefaultComboBoxModel<CsvFormat.FileFormat>(CsvFormat.FileFormat.values()));
        this.fileFormatCB.setSelectedItem((Object)DEFAULT_FILE_FORMAT);
        this.fileFormatCB.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.fileFormatSelectionChanged();
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFormat, GroupLayout.Alignment.TRAILING)).addGroup(groupLayout.createParallelGroup().addComponent(this.fileFormatCB)).addGroup(groupLayout.createParallelGroup().addComponent(lblFormatHelp)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFormat, GroupLayout.Alignment.CENTER).addComponent(this.fileFormatCB, GroupLayout.Alignment.CENTER).addComponent(lblFormatHelp, GroupLayout.Alignment.CENTER)));
        return northPane;
    }

    private Component getCenterPane() {
        JXTaskPaneContainer customOptionsTaskPaneContainer = new JXTaskPaneContainer();
        customOptionsTaskPaneContainer.setOpaque(false);
        customOptionsTaskPaneContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.customFormatOptionsTaskPane = new JXTaskPane();
        this.customFormatOptionsTaskPane.setTitle("Custom format");
        this.customFormatOptionsTaskPane.setCollapsed(true);
        this.customFormatOptionsTaskPane.addPropertyChangeListener("collapsed", e -> this.formatCustomized());
        JPanel customOptionsPane = new JPanel();
        GroupLayout customOptionsGroupLayout = new GroupLayout(customOptionsPane);
        customOptionsGroupLayout.setAutoCreateContainerGaps(true);
        customOptionsGroupLayout.setAutoCreateGaps(true);
        customOptionsPane.setLayout(customOptionsGroupLayout);
        this.customFormatOptionsTaskPane.add((Component)customOptionsPane, "Center");
        customOptionsTaskPaneContainer.add(this.customFormatOptionsTaskPane);
        ItemListener columnSeparatorListener = e -> {
            if (e.getStateChange() == 1 && !this.updateWithoutEvents) {
                this.checkCustomSeparatorButtons();
            }
        };
        ItemListener itemListener = e -> {
            if (e.getStateChange() == 1 && !this.updateWithoutEvents) {
                this.formatCustomized();
            }
        };
        JLabel lblQuoteFields = new JLabel("Quote fields");
        JLabel lblQuoteFieldsHelp = new JLabel(Icons.ICON_INFO_2_16);
        lblQuoteFieldsHelp.setToolTipText("Sets whether fields must be delimited by double quotes.");
        JPanel quotePanel = new JPanel(new GridLayout(1, 1));
        this.quoteFields = new JCheckBox("", false);
        this.quoteFields.addItemListener(itemListener);
        quotePanel.add(this.quoteFields);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.notifyUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void notifyUpdate() {
                if (!CsvPanel.this.updateWithoutEvents) {
                    CsvPanel.this.textFieldChanged();
                }
            }
        };
        JLabel lblColumnSeparator = new JLabel("Column separator");
        JLabel lblColumnSeparatorHelp = new JLabel(Icons.ICON_INFO_2_16);
        lblColumnSeparatorHelp.setToolTipText("Sets the column separator");
        JPanel columnSeparatorPanel = new JPanel(new GridLayout(1, 3));
        this.rbtnSepTab = new JRadioButton("Tabulator");
        this.rbtnSepTab.setSelected(false);
        this.rbtnSepCustom = new JRadioButton("CUSTOM");
        this.rbtnSepCustom.setSelected(true);
        this.txtFieldCustomColumnSeparator = new JLimitedTextField(",", 1, 3);
        this.txtFieldCustomColumnSeparator.getDocument().addDocumentListener(documentListener);
        Dimension size = new Dimension(25, 25);
        this.txtFieldCustomColumnSeparator.setMaximumSize(size);
        this.txtFieldCustomColumnSeparator.setSize(size);
        this.txtFieldCustomColumnSeparator.addFocusListener(FOCUS_LISTENER);
        JPanel customColumnSeparatorTFPanel = new JPanel();
        BoxLayout cCSPanelLayout = new BoxLayout(customColumnSeparatorTFPanel, 0);
        customColumnSeparatorTFPanel.setLayout(cCSPanelLayout);
        customColumnSeparatorTFPanel.add(Box.createHorizontalGlue(), "East");
        customColumnSeparatorTFPanel.add(this.txtFieldCustomColumnSeparator);
        columnSeparatorPanel.add(this.rbtnSepTab);
        columnSeparatorPanel.add(this.rbtnSepCustom);
        columnSeparatorPanel.add(customColumnSeparatorTFPanel);
        ButtonGroup separatorGroup = new ButtonGroup();
        separatorGroup.add(this.rbtnSepTab);
        separatorGroup.add(this.rbtnSepCustom);
        this.rbtnSepTab.addItemListener(columnSeparatorListener);
        this.rbtnSepCustom.addItemListener(columnSeparatorListener);
        this.rbtnSepTab.addItemListener(itemListener);
        this.rbtnSepCustom.addItemListener(itemListener);
        JLabel lblDecimalSeparator = new JLabel("Decimal separator");
        JLabel lblDecimalSeparatorHelp = new JLabel(Icons.ICON_INFO_2_16);
        lblDecimalSeparatorHelp.setToolTipText("Sets the decimal separator");
        JPanel decimalSeparatorPanel = new JPanel(new GridLayout(1, 4));
        this.rbtnDecimalSepPoint = new JRadioButton("Point");
        this.rbtnDecimalSepPoint.setSelected(true);
        this.rbtnDecimalSepPoint.addItemListener(itemListener);
        this.rbtnDecimalSepComma = new JRadioButton("Comma");
        this.rbtnDecimalSepComma.setSelected(false);
        this.rbtnDecimalSepComma.addItemListener(itemListener);
        this.rbtnDecimalSepCustom = new JRadioButton("CUSTOM");
        this.rbtnDecimalSepCustom.setSelected(false);
        this.rbtnDecimalSepCustom.addItemListener(itemListener);
        this.txtFieldCustomDecimalPoint = new JLimitedTextField(".", 1, 3);
        this.txtFieldCustomDecimalPoint.getDocument().addDocumentListener(documentListener);
        this.txtFieldCustomDecimalPoint.setMaximumSize(size);
        this.txtFieldCustomDecimalPoint.setSize(size);
        this.txtFieldCustomDecimalPoint.addFocusListener(FOCUS_LISTENER);
        JPanel customDecimalPointTFPanel = new JPanel();
        BoxLayout cDPPanelLayout = new BoxLayout(customDecimalPointTFPanel, 0);
        customDecimalPointTFPanel.setLayout(cDPPanelLayout);
        customDecimalPointTFPanel.add(Box.createHorizontalGlue(), "East");
        customDecimalPointTFPanel.add((Component)this.txtFieldCustomDecimalPoint, "East");
        decimalSeparatorPanel.add(this.rbtnDecimalSepPoint);
        decimalSeparatorPanel.add(this.rbtnDecimalSepComma);
        decimalSeparatorPanel.add(this.rbtnDecimalSepCustom);
        decimalSeparatorPanel.add(customDecimalPointTFPanel);
        ButtonGroup decimalPointGroup = new ButtonGroup();
        decimalPointGroup.add(this.rbtnDecimalSepPoint);
        decimalPointGroup.add(this.rbtnDecimalSepComma);
        decimalPointGroup.add(this.rbtnDecimalSepCustom);
        ItemListener decimalPointListener = e -> {
            if (e.getStateChange() == 1 && !this.updateWithoutEvents) {
                this.checkDecimalPointButtons();
            }
        };
        this.rbtnDecimalSepPoint.addItemListener(decimalPointListener);
        this.rbtnDecimalSepComma.addItemListener(decimalPointListener);
        this.rbtnDecimalSepCustom.addItemListener(decimalPointListener);
        JLabel lblLineSeparator = new JLabel("Line break");
        JLabel lblLineSeparatorHelp = new JLabel(Icons.ICON_INFO_2_16);
        lblLineSeparatorHelp.setToolTipText("Sets the line break");
        JPanel lineSeparatorPanel = new JPanel(new GridLayout(1, 3));
        this.rbtnLineSepWindows = new JRadioButton("Windows");
        this.rbtnLineSepWindows.setSelected(true);
        this.rbtnLineSepWindows.addItemListener(itemListener);
        this.rbtnLineSepLinux = new JRadioButton("Linux");
        this.rbtnLineSepLinux.setSelected(false);
        this.rbtnLineSepLinux.addItemListener(itemListener);
        this.rbtnLineSepMacOS = new JRadioButton("Mac OS X");
        this.rbtnLineSepMacOS.setSelected(false);
        this.rbtnLineSepMacOS.addItemListener(itemListener);
        lineSeparatorPanel.add(this.rbtnLineSepWindows);
        lineSeparatorPanel.add(this.rbtnLineSepLinux);
        lineSeparatorPanel.add(this.rbtnLineSepMacOS);
        ButtonGroup lineBreakGroup = new ButtonGroup();
        lineBreakGroup.add(this.rbtnLineSepWindows);
        lineBreakGroup.add(this.rbtnLineSepLinux);
        lineBreakGroup.add(this.rbtnLineSepMacOS);
        customOptionsGroupLayout.setHorizontalGroup(customOptionsGroupLayout.createSequentialGroup().addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblQuoteFields, GroupLayout.Alignment.TRAILING).addComponent(lblColumnSeparator, GroupLayout.Alignment.TRAILING).addComponent(lblDecimalSeparator, GroupLayout.Alignment.TRAILING).addComponent(lblLineSeparator, GroupLayout.Alignment.TRAILING)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(quotePanel).addComponent(columnSeparatorPanel).addComponent(decimalSeparatorPanel).addComponent(lineSeparatorPanel)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblQuoteFieldsHelp).addComponent(lblColumnSeparatorHelp).addComponent(lblDecimalSeparatorHelp).addComponent(lblLineSeparatorHelp)));
        customOptionsGroupLayout.setVerticalGroup(customOptionsGroupLayout.createSequentialGroup().addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblQuoteFields, GroupLayout.Alignment.CENTER).addComponent(quotePanel, GroupLayout.Alignment.CENTER).addComponent(lblQuoteFieldsHelp, GroupLayout.Alignment.CENTER)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblColumnSeparator, GroupLayout.Alignment.CENTER).addComponent(columnSeparatorPanel, GroupLayout.Alignment.CENTER).addComponent(lblColumnSeparatorHelp, GroupLayout.Alignment.CENTER)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblDecimalSeparator, GroupLayout.Alignment.CENTER).addComponent(decimalSeparatorPanel, GroupLayout.Alignment.CENTER).addComponent(lblDecimalSeparatorHelp, GroupLayout.Alignment.CENTER)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblLineSeparator, GroupLayout.Alignment.CENTER).addComponent(lineSeparatorPanel, GroupLayout.Alignment.CENTER).addComponent(lblLineSeparatorHelp, GroupLayout.Alignment.CENTER)));
        return customOptionsTaskPaneContainer;
    }

    private void formatCustomized() {
        if (!this.fileFormatCB.getSelectedItem().equals((Object)CsvFormat.FileFormat.CUSTOM)) {
            this.fileFormatCB.setSelectedItem((Object)CsvFormat.FileFormat.CUSTOM);
        } else {
            this.checkSeparators(true);
        }
        this.csvFormatEdited();
    }

    private void fileFormatSelectionChanged() {
        CsvFormat.FileFormat selectedItem = (CsvFormat.FileFormat)((Object)this.fileFormatCB.getSelectedItem());
        this.customFormatOptionsTaskPane.setCollapsed(!selectedItem.equals((Object)CsvFormat.FileFormat.CUSTOM));
        if (!selectedItem.equals((Object)CsvFormat.FileFormat.CUSTOM)) {
            this.updateWithoutEvents = true;
            this.updateCustomValues(selectedItem);
            this.updateWithoutEvents = false;
        }
        this.csvFormatEdited();
    }

    private void updateCustomValues(CsvFormat.FileFormat format) {
        this.rbtnDecimalSepCustom.setSelected(true);
        this.rbtnSepCustom.setSelected(true);
        this.quoteFields.setSelected(false);
        this.txtFieldCustomDecimalPoint.setText(String.valueOf(this.symbols.getDecimalSeparator()));
        if (format.equals((Object)CsvFormat.FileFormat.EXCEL)) {
            this.rbtnLineSepWindows.setSelected(true);
            this.txtFieldCustomColumnSeparator.setText(";");
        } else if (format.equals((Object)CsvFormat.FileFormat.LIBRE_OFFICE)) {
            this.rbtnLineSepLinux.setSelected(true);
            if (this.symbols.getDecimalSeparator() == ',') {
                this.txtFieldCustomColumnSeparator.setText(";");
            } else {
                this.txtFieldCustomColumnSeparator.setText(",");
            }
        }
    }

    private void checkCustomSeparatorButtons() {
        this.txtFieldCustomColumnSeparator.setEditable(this.rbtnSepCustom.isSelected());
    }

    private void checkDecimalPointButtons() {
        this.txtFieldCustomDecimalPoint.setEditable(this.rbtnDecimalSepCustom.isSelected());
    }

    private void textFieldChanged() {
        SwingUtilities.invokeLater(() -> {
            this.checkSeparators(true);
            this.csvFormatEdited();
        });
    }

    private boolean checkSeparators(boolean gui) {
        if (this.fileFormatCB.getSelectedItem().equals((Object)CsvFormat.FileFormat.CUSTOM) && !this.getColumnSeparator().equals("") && this.getColumnSeparator().charAt(0) == this.getDecimalSeparator()) {
            if (gui) {
                JOptionPane.showMessageDialog(this, "You have selected the same column and decimal separator, which may result in an unreadable file.", "Invalid configuration", 2);
            }
            return false;
        }
        return true;
    }

    private void csvFormatEdited() {
        this.fireOnCsvFormatEditedEvent();
    }

    private void fireOnCsvFormatEditedEvent() {
        Arrays.asList(this.getCsvListeners()).forEach(l -> l.onFormatEdited(new ChangeEvent(this)));
    }

    private String getColumnSeparator() {
        String columnSeparator = this.rbtnSepTab.isSelected() ? "\t" : (this.rbtnSepCustom.isSelected() ? this.txtFieldCustomColumnSeparator.getText() : null);
        return columnSeparator;
    }

    private char getDecimalSeparator() {
        int decimalSeparator = this.rbtnDecimalSepComma.isSelected() ? 44 : (this.rbtnDecimalSepPoint.isSelected() ? 46 : (this.rbtnDecimalSepCustom.isSelected() ? (int)this.txtFieldCustomDecimalPoint.getText().charAt(0) : 0));
        return (char)decimalSeparator;
    }

    public boolean isValidFormat() {
        return this.checkSeparators(false);
    }

    public void setSelectedCsvFileFormat(CsvFormat.FileFormat format) {
        this.fileFormatCB.setSelectedItem((Object)format);
    }

    public CsvFormat getCsvFormat() {
        CsvFormat toret;
        CsvFormat.FileFormat selectedFormat = (CsvFormat.FileFormat)((Object)this.fileFormatCB.getSelectedItem());
        if (selectedFormat.equals((Object)CsvFormat.FileFormat.EXCEL) || selectedFormat.equals((Object)CsvFormat.FileFormat.LIBRE_OFFICE)) {
            try {
                toret = new CsvFormat(selectedFormat);
            }
            catch (Exception e) {
                return null;
            }
        } else {
            toret = new CsvFormat(this.getColumnSeparator(), this.getDecimalSeparator(), this.quoteFields.isSelected(), this.getLineBreak());
        }
        return toret;
    }

    private String getLineBreak() {
        String lineBreak = this.rbtnLineSepWindows.isSelected() ? "\r\n" : "\n";
        return lineBreak;
    }

    public synchronized void addCsvListener(CsvListener l) {
        this.listenerList.add(CsvListener.class, l);
    }

    public synchronized CsvListener[] getCsvListeners() {
        return (CsvListener[])this.listenerList.getListeners(CsvListener.class);
    }
}

