/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.commons.csv.entities;

import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class CsvData
extends ArrayList<CsvEntry> {
    private static final long serialVersionUID = 1L;
    private CsvEntry header;
    private CsvFormat format;

    private CsvData(Collection<? extends CsvEntry> items, CsvEntry header, CsvFormat format) {
        super(items);
        this.setFormat(format);
        this.setHeader(header);
    }

    private void setFormat(CsvFormat format) {
        Objects.requireNonNull(format);
        this.format = format;
    }

    private void setHeader(CsvEntry header) {
        Objects.requireNonNull(header);
        this.header = header;
    }

    public boolean hasHeader() {
        return !this.header.isEmpty();
    }

    public CsvEntry getHeader() {
        return this.header;
    }

    public CsvFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean equals(Object aThat) {
        if (aThat == null) {
            return false;
        }
        if (!(aThat instanceof CsvData)) {
            return false;
        }
        CsvData that = (CsvData)aThat;
        return this.header.equals(that.header) && this.format.equals(that.format) && super.equals(that);
    }

    private static void requireCompatibleEntries(List<CsvEntry> entries, CsvEntry header) {
        Stream<Integer> entriesSize = CsvData.getSizes(entries).distinct();
        if (entriesSize.count() > 1L) {
            throw new IllegalArgumentException("All entries must have the same length");
        }
        Integer numColumns = CsvData.getSizes(entries).findAny().get();
        if (!header.isEmpty() && numColumns.intValue() != header.size()) {
            throw new IllegalArgumentException("Header and entries must have the same length");
        }
    }

    private static Stream<Integer> getSizes(List<CsvEntry> entries) {
        return entries.stream().map(ArrayList::size);
    }

    /* synthetic */ CsvData(Collection collection, CsvEntry csvEntry, CsvFormat csvFormat, CsvData csvData) {
        this(collection, csvEntry, csvFormat);
    }

    public static class CsvDataBuilder {
        private CsvFormat format;
        private List<CsvEntry> entries = new ArrayList<CsvEntry>();
        private CsvEntry header = new CsvEntry();

        private CsvDataBuilder(CsvFormat format) {
            this.format = format;
        }

        public static CsvDataBuilder newCsvDataBuilder(CsvFormat format) {
            return new CsvDataBuilder(Objects.requireNonNull(format, "CsvFormat can't be null"));
        }

        public CsvDataBuilder withEntries(List<CsvEntry> entries) {
            this.entries = Objects.requireNonNull(entries, "Entries list can't be null");
            return this;
        }

        public CsvDataBuilder withHeader(CsvEntry header) {
            this.header = Objects.requireNonNull(header, "Header entry can't be null");
            return this;
        }

        public CsvData build() {
            CsvData.requireCompatibleEntries(this.entries, this.header);
            CsvData instance = new CsvData(this.entries, this.header, this.format, null);
            return instance;
        }
    }
}

