/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bedtools.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesChecker;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;

public abstract class AbstractBedToolsBinariesExecutor
extends AbstractBinariesExecutor
implements BedToolsBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        BedToolsBinariesChecker.checkBedToolsBinary(this.getBedToolsCommand());
    }

    protected abstract String getBedToolsCommand();

    protected abstract String toFilePath(File var1);

    protected void getFasta(List<String> bedToolsCommand, File inputFasta, File bedFile, File output, String additionalParameters) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(bedToolsCommand);
        parameters.addAll(Arrays.asList("getfasta", "-fi", this.toFilePath(inputFasta), "-bed", this.toFilePath(bedFile), "-fo", this.toFilePath(output)));
        if (!additionalParameters.isEmpty()) {
            parameters.addAll(this.getAdditionalParameters(additionalParameters));
        }
        this.executeCommand(parameters);
    }

    private Collection<? extends String> getAdditionalParameters(String additionalParameters) {
        return Arrays.asList(additionalParameters.split(" "));
    }
}

