/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.table.csv;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.sing_group.gc4s.dialog.ExportCsvDialog;
import org.sing_group.gc4s.visualization.table.csv.BasicTransferable;
import org.sing_group.gc4s.visualization.table.csv.CsvTableExporter;
import org.sing_group.gc4s.visualization.table.csv.CsvTransferHandler;
import org.sing_group.gc4s.visualization.table.csv.DefaultCsvTableExporter;

public class CsvTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_EXPORT_CSV = "column.export";
    private CsvTransferHandler transferHandler;
    private Map<Integer, String> formats;
    private Map<Integer, TableCellRenderer> columnRenderers;
    private Action actionExportCsv = new AbstractAction("Export to CSV"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            CsvTable.this.exportToCsv();
        }
    };

    public CsvTable() {
        this.configure();
    }

    public CsvTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.configure();
    }

    public CsvTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.configure();
    }

    public CsvTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.configure();
    }

    public CsvTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.configure();
    }

    public CsvTable(TableModel dm) {
        super(dm);
        this.configure();
    }

    public CsvTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
        this.configure();
    }

    public void setFormat(int modelColumn, String format) {
        this.formats.put(modelColumn, format);
    }

    public String getFormat(int modelColumn) {
        return this.formats.get(modelColumn);
    }

    public void removeFormat(int modelColumn) {
        this.formats.remove(modelColumn);
    }

    public void setConverter(int modelColumn, CsvTransferHandler.Converter converter) {
        this.transferHandler.setConverter(modelColumn, converter);
    }

    public CsvTransferHandler.Converter getConverter(int modelColumn) {
        return this.transferHandler.getConverter(modelColumn);
    }

    public void removeConverter(int modelColumn) {
        this.transferHandler.removeConverter(modelColumn);
    }

    public void exportViewToFile(File file) throws FileNotFoundException {
        this.selectAll();
        BasicTransferable transferable = this.transferHandler.createTransferable((JComponent)((Object)this));
        if (transferable == null) {
            throw new RuntimeException("There's not data to export.");
        }
        try (PrintWriter pw = new PrintWriter(file);){
            pw.print(transferable.getPlainData());
        }
        this.clearSelection();
    }

    public void exportSelectionToFile(File file) throws FileNotFoundException {
        BasicTransferable transferable = this.transferHandler.createTransferable((JComponent)((Object)this));
        if (transferable == null) {
            throw new RuntimeException("There's not data to export.");
        }
        if (transferable.getPlainData().trim().equals("")) {
            throw new RuntimeException("No cell selected");
        }
        try (PrintWriter pw = new PrintWriter(file);){
            pw.print(transferable.getPlainData());
        }
    }

    public TableCellRenderer setColumnCellRenderer(int index, TableCellRenderer renderer) {
        return this.columnRenderers.put(index, renderer);
    }

    public TableCellRenderer getColumnCellRenderer(int index) {
        return this.columnRenderers.get(index);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        try {
            if (this.columnRenderers.containsKey(column)) {
                return this.columnRenderers.get(column);
            }
            if (this.getValueAt(row, column) instanceof Float) {
                return this.getDefaultRenderer(Float.class);
            }
            if (this.getValueAt(row, column) instanceof Double) {
                return this.getDefaultRenderer(Double.class);
            }
            return super.getCellRenderer(row, column);
        }
        catch (Exception e) {
            return super.getCellRenderer(row, column);
        }
    }

    private void configure() {
        this.getActionMap().put(ACTION_EXPORT_CSV, this.actionExportCsv);
        this.transferHandler = new CsvTransferHandler();
        this.formats = new HashMap<Integer, String>();
        this.columnRenderers = new HashMap<Integer, TableCellRenderer>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.formats.put(i, "%.4f");
        }
        this.setCellSelectionEnabled(true);
        this.setColumnControlVisible(true);
        this.setTransferHandler(this.transferHandler);
        this.setEditable(false);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if ((value instanceof Float || value instanceof Double) && component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    label.setHorizontalAlignment(4);
                    int modelColumn = table.convertColumnIndexToModel(column);
                    label.setText(String.format((String)CsvTable.this.formats.get(modelColumn), value));
                }
                return component;
            }
        };
        this.setDefaultRenderer(Float.class, renderer);
        this.setDefaultRenderer(Double.class, renderer);
    }

    private Window getDialogsFrame() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    protected void exportToCsv() {
        ExportCsvDialog dialog = new ExportCsvDialog(this.getDialogsFrame());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            try {
                this.saveToCSV((JTable)((Object)this), new DefaultCsvTableExporter(dialog.getSelectedCsvFormat()), dialog.getSelectedFile());
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(this.getDialogsFrame(), "An error occured while exporting the table.", "Export Error", 0);
            }
        }
    }

    private final void saveToCSV(JTable table, CsvTableExporter exporter, File file) throws FileNotFoundException {
        StringBuilder plainSB = new StringBuilder();
        for (int j = 0; j < table.getColumnCount(); ++j) {
            String columnName = table.getColumnName(j);
            if (exporter.quoteFields()) {
                plainSB.append("\"").append(columnName).append("\"").append(exporter.getColumnSeparator());
                continue;
            }
            plainSB.append(columnName).append(exporter.getColumnSeparator());
        }
        plainSB.replace(plainSB.length() - 1, plainSB.length(), exporter.getLineBreak());
        for (int i = 0; i < table.getRowCount(); ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (exporter.quoteFields()) {
                    plainSB.append("\"").append(exporter.parseValue(table.getValueAt(i, j))).append("\"").append(exporter.getColumnSeparator());
                    continue;
                }
                plainSB.append(exporter.parseValue(table.getValueAt(i, j))).append(exporter.getColumnSeparator());
            }
            plainSB.deleteCharAt(plainSB.length() - 1).append(exporter.getLineBreak());
        }
        try (PrintWriter pw = new PrintWriter(file);){
            pw.print(plainSB.toString());
        }
    }

    public void disableColumVisibilityActions() {
        this.setColumnControl((JComponent)((Object)new CustomColumnControlButton(this)));
    }

    private class CustomColumnControlButton
    extends ColumnControlButton {
        private static final long serialVersionUID = 1L;

        public CustomColumnControlButton(JXTable table) {
            super(table);
        }

        protected void createVisibilityActions() {
        }
    }
}

