/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.utilities.builder;

import java.awt.event.ItemEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class JToggleButtonBuilder<T extends JToggleButton> {
    private final Supplier<T> constructor;
    private Boolean selected;
    private Boolean enabled;
    private Boolean focusable;
    private String label;
    private ImageIcon selectedIcon;
    private ImageIcon unselectedIcon;
    private String tooltip;
    private Function<Boolean, String> tooltipFunction;
    private Consumer<ItemEvent> onItemStateChanged;

    private JToggleButtonBuilder(Supplier<T> constructor) {
        this.constructor = constructor;
    }

    public static JToggleButtonBuilder<JToggleButton> newJToggleButton() {
        return JToggleButtonBuilder.newJToggleButton(JToggleButton::new);
    }

    public static <T extends JToggleButton> JToggleButtonBuilder<T> newJToggleButton(Supplier<T> constructor) {
        return new JToggleButtonBuilder<T>(constructor);
    }

    public JToggleButtonBuilder<T> setSelected(Boolean selected) {
        this.selected = selected;
        return this;
    }

    public JToggleButtonBuilder<T> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public JToggleButtonBuilder<T> setFocusable(Boolean focusable) {
        this.focusable = focusable;
        return this;
    }

    public JToggleButtonBuilder<T> withSelectedIcon(ImageIcon selectedIcon) {
        this.selectedIcon = selectedIcon;
        return this;
    }

    public JToggleButtonBuilder<T> withUnselectedIcon(ImageIcon unselectedIcon) {
        this.unselectedIcon = unselectedIcon;
        return this;
    }

    public JToggleButtonBuilder<T> withLabel(String label) {
        this.label = label;
        return this;
    }

    public JToggleButtonBuilder<T> withTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public JToggleButtonBuilder<T> withTooltip(Function<Boolean, String> tooltipFunction) {
        this.tooltipFunction = tooltipFunction;
        return this;
    }

    public JToggleButtonBuilder<T> thatDoes(Consumer<ItemEvent> onItemStateChanged) {
        this.onItemStateChanged = onItemStateChanged;
        return this;
    }

    public T build() {
        JToggleButton instance = (JToggleButton)this.constructor.get();
        if (this.selected != null) {
            instance.setSelected(this.selected);
        }
        if (this.enabled != null) {
            instance.setEnabled(this.enabled);
        }
        if (this.focusable != null) {
            instance.setFocusable(this.focusable);
            instance.setFocusPainted(this.focusable);
        }
        if (this.label != null) {
            instance.setText(this.label);
        }
        if (this.selectedIcon != null) {
            instance.setSelectedIcon(this.selectedIcon);
            instance.setDisabledSelectedIcon(this.selectedIcon);
            instance.setRolloverSelectedIcon(this.selectedIcon);
        }
        if (this.unselectedIcon != null) {
            instance.setIcon(this.unselectedIcon);
            instance.setDisabledIcon(this.unselectedIcon);
            instance.setRolloverIcon(this.unselectedIcon);
        }
        if (this.tooltipFunction != null) {
            instance.setToolTipText(this.tooltipFunction.apply(this.selected));
            instance.addItemListener(e -> instance.setToolTipText(this.tooltipFunction.apply(instance.isSelected())));
        } else if (this.tooltip != null) {
            instance.setToolTipText(this.tooltip);
        }
        if (this.onItemStateChanged != null) {
            instance.addItemListener(e -> this.onItemStateChanged.accept(e));
        }
        return (T)instance;
    }
}

