/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.list;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FilteredListModel<E>
extends AbstractListModel<E> {
    private static final long serialVersionUID = 1L;
    private final ListModel<E> _source;
    private Filter _filter;
    private final ArrayList<Integer> _indices = new ArrayList();

    public FilteredListModel(ListModel<E> source) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        this._source = source;
        this._source.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }
        });
    }

    public void setFilter(Filter f) {
        this._filter = f;
        this.doFilter();
    }

    private void doFilter() {
        this._indices.clear();
        Filter f = this._filter;
        if (f != null) {
            int count = this._source.getSize();
            for (int i = 0; i < count; ++i) {
                E element = this._source.getElementAt(i);
                if (!f.accept(element)) continue;
                this._indices.add(i);
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    @Override
    public int getSize() {
        return this._filter != null ? this._indices.size() : this._source.getSize();
    }

    @Override
    public E getElementAt(int index) {
        return this._filter != null ? this._source.getElementAt(this._indices.get(index)) : this._source.getElementAt(index);
    }

    public ListModel<E> getSourceListModel() {
        return this._source;
    }

    public static interface Filter {
        public boolean accept(Object var1);
    }
}

