/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.filechooser;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileFilter;
import org.sing_group.gc4s.event.ListDataAdapter;
import org.sing_group.gc4s.input.filechooser.JFileChooserConfiguration;
import org.sing_group.gc4s.input.filechooser.Mode;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.input.filechooser.event.MultipleFileChooserListener;
import org.sing_group.gc4s.input.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.input.list.JListPanel;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.FileDrop;
import org.sing_group.gc4s.utilities.FileDropListener;

public class JMultipleFileChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final ImageIcon DEFAULT_ICON_BROWSE = Icons.ICON_BROWSE_16;
    public static final SelectionMode DEFAULT_SELECTION_MODE = SelectionMode.FILES_DIRECTORIES;
    public static final boolean DEFAULT_ALLOW_ALL_FILTER = true;
    public static final boolean DEFAULT_CLEAR_SELECTED_FILE_ON_SHOW = false;
    public static final List<FileFilter> DEFAULT_FILE_FILTERS = Collections.emptyList();
    private JFileChooser filechooser;
    private Mode mode;
    private AbstractAction browseAction;
    private JFileChooserConfiguration fileChooserConfiguration;
    private boolean useSharedLastFileFilter = false;
    private static FileFilter LAST_FILE_FILTER;
    private FileFilter lastFileFilter;
    private JListPanel<File> selectedFilesListPanel;
    private ExtendedDefaultListModel<File> selectedFilesModel;

    public JMultipleFileChooserPanel(Mode mode) {
        this(mode, new JFileChooser(), DEFAULT_ICON_BROWSE, DEFAULT_SELECTION_MODE);
    }

    public JMultipleFileChooserPanel(Mode mode, JFileChooser filechooser) {
        this(mode, filechooser, DEFAULT_ICON_BROWSE, DEFAULT_SELECTION_MODE);
    }

    public JMultipleFileChooserPanel(Mode mode, SelectionMode selectionMode, JFileChooser filechooser) {
        this(mode, filechooser, DEFAULT_ICON_BROWSE, selectionMode);
    }

    public JMultipleFileChooserPanel(Mode mode, JFileChooser filechooser, ImageIcon browseIcon, SelectionMode selectionMode) {
        this(mode, filechooser, browseIcon, selectionMode, true, false, DEFAULT_FILE_FILTERS);
    }

    public JMultipleFileChooserPanel(Mode mode, JFileChooser filechooser, ImageIcon browseIcon, SelectionMode selectionMode, boolean allowAll, boolean clearSelectedFileOnShow, List<FileFilter> fileFilters) {
        this.filechooser = filechooser;
        this.mode = mode;
        this.fileChooserConfiguration = new JFileChooserConfiguration(selectionMode.getFileSelectionMode(), fileFilters, allowAll, clearSelectedFileOnShow);
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.selectedFilesModel = new ExtendedDefaultListModel();
        this.selectedFilesModel.addExtendedDefaultListModelListener(src -> this.fireFileChoosedEvent());
        this.selectedFilesModel.addListDataListener(new ListDataAdapter(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JMultipleFileChooserPanel.this.fireFileRemovedEvent();
            }
        });
        JList<File> list = new JList<File>(this.selectedFilesModel);
        try {
            this.selectedFilesListPanel = new JListPanel<File>(list, true, false);
            this.selectedFilesListPanel.getBtnMoveDown().setVisible(false);
            this.selectedFilesListPanel.getBtnMoveUp().setVisible(false);
            this.selectedFilesListPanel.addAction(this.getBrowseAction());
            this.add(this.selectedFilesListPanel, "Center");
        }
        catch (InvalidClassException e1) {
            throw new RuntimeException(e1);
        }
        new FileDrop(list, new FileDropListener(){

            @Override
            public void filesDropped(File[] files) {
                JMultipleFileChooserPanel.this.setSelectedFiles(files);
            }
        });
    }

    private void fireFileChoosedEvent() {
        Arrays.asList(this.getFileChooserListeners()).forEach(l -> l.onFileChoosed(new ChangeEvent(this)));
    }

    private void fireFileRemovedEvent() {
        Arrays.asList(this.getFileChooserListeners()).forEach(l -> l.onFileRemoved(new ChangeEvent(this)));
    }

    private void onBrowse() {
        JFileChooser fileChooser = this.getConfiguredFileChooser();
        int returnVal = this.mode.equals((Object)Mode.SAVE) ? fileChooser.showSaveDialog(this) : fileChooser.showOpenDialog(this);
        this.saveLastFileFilter(fileChooser.getFileFilter());
        if (returnVal == 0) {
            this.setSelectedFiles(fileChooser.getSelectedFiles());
        }
        this.clearFileChooser();
    }

    private void saveLastFileFilter(FileFilter fileFilter) {
        this.lastFileFilter = fileFilter;
        if (this.useSharedLastFileFilter) {
            LAST_FILE_FILTER = this.lastFileFilter;
        }
    }

    private JFileChooser getConfiguredFileChooser() {
        JFileChooser fileChooser = this.getFilechooser();
        this.fileChooserConfiguration.configure(fileChooser);
        this.configureLastFileFilter(fileChooser);
        fileChooser.setMultiSelectionEnabled(true);
        return fileChooser;
    }

    private void configureLastFileFilter(JFileChooser fileChooser) {
        if (this.useSharedLastFileFilter) {
            if (!JMultipleFileChooserPanel.setFileFilter(fileChooser, LAST_FILE_FILTER) && JMultipleFileChooserPanel.isAcceptAllFileFilter(LAST_FILE_FILTER)) {
                this.setAcceptAllFileFilter(fileChooser);
            }
        } else {
            JMultipleFileChooserPanel.setFileFilter(fileChooser, this.lastFileFilter);
        }
    }

    private static boolean setFileFilter(JFileChooser fileChooser, FileFilter filter) {
        if (filter != null && JMultipleFileChooserPanel.containsFilter(fileChooser, filter)) {
            fileChooser.setFileFilter(filter);
            return true;
        }
        return false;
    }

    private static boolean containsFilter(JFileChooser fileChooser, FileFilter filter) {
        return JMultipleFileChooserPanel.getFileFilters(fileChooser).contains(filter);
    }

    private static List<FileFilter> getFileFilters(JFileChooser fileChooser) {
        return Arrays.asList(fileChooser.getChoosableFileFilters());
    }

    private static boolean isAcceptAllFileFilter(FileFilter filter) {
        return filter != null && filter.getClass().getSimpleName().equals("AcceptAllFileFilter");
    }

    private void setAcceptAllFileFilter(JFileChooser fileChooser) {
        Optional<FileFilter> acceptAllFileFilter = JMultipleFileChooserPanel.findAcceptAllFileFilter(fileChooser);
        if (acceptAllFileFilter.isPresent()) {
            fileChooser.setFileFilter(acceptAllFileFilter.get());
        }
    }

    private static Optional<FileFilter> findAcceptAllFileFilter(JFileChooser fileChooser) {
        return JMultipleFileChooserPanel.getFileFilters(fileChooser).stream().filter(JMultipleFileChooserPanel::isAcceptAllFileFilter).findAny();
    }

    private void clearFileChooser() {
        this.getFilechooser().setFileSelectionMode(2);
    }

    public void setSelectedFiles(File[] files) {
        this.selectedFilesModel.addElements(Arrays.asList(files));
        this.selectedFilesListPanel.getList().updateUI();
    }

    public void clearSelectedFiles() {
        this.selectedFilesModel.removeAllElements();
        this.selectedFilesListPanel.getList().updateUI();
    }

    public JFileChooser getFilechooser() {
        return this.filechooser;
    }

    public AbstractAction getBrowseAction() {
        if (this.browseAction == null) {
            this.browseAction = new AbstractAction("Browse", DEFAULT_ICON_BROWSE){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMultipleFileChooserPanel.this.onBrowse();
                }
            };
        }
        return this.browseAction;
    }

    public List<File> getSelectedFiles() {
        LinkedList<File> toret = new LinkedList<File>();
        Enumeration elements = this.selectedFilesModel.elements();
        while (elements.hasMoreElements()) {
            toret.add((File)elements.nextElement());
        }
        return toret;
    }

    public void setUseSharedLastFileFilter(boolean use) {
        this.useSharedLastFileFilter = use;
    }

    public static void clearSharedLastFileFilter() {
        LAST_FILE_FILTER = null;
    }

    public synchronized void addFileChooserListener(MultipleFileChooserListener l) {
        this.listenerList.add(MultipleFileChooserListener.class, l);
    }

    public synchronized MultipleFileChooserListener[] getFileChooserListeners() {
        return (MultipleFileChooserListener[])this.listenerList.getListeners(MultipleFileChooserListener.class);
    }
}

