/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import org.sing_group.gc4s.dialog.AbstractInputJDialog;
import org.sing_group.gc4s.event.ListDataAdapter;
import org.sing_group.gc4s.input.list.ColorsListPanel;

public class ColorsSelectionDialog
extends AbstractInputJDialog {
    private static final long serialVersionUID = 1L;
    private JPanel inputComponents;
    private ColorsListPanel colorsListPanel;
    private int min;
    private int max;

    public ColorsSelectionDialog(Window parent, int min, int max) {
        this(parent, min, max, Collections.emptyList());
    }

    public ColorsSelectionDialog(Window parent, int min, int max, List<Color> colors) {
        super(parent);
        this.min = min;
        this.max = max;
        this.init(colors);
    }

    private void init(List<Color> colors) {
        this.colorsListPanel = new ColorsListPanel();
        this.colorsListPanel.addColors(colors);
        this.colorsListPanel.addListDataListener(new ListDataAdapter(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ColorsSelectionDialog.this.checkOkButton();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ColorsSelectionDialog.this.checkOkButton();
            }
        });
        this.inputComponents.add(this.colorsListPanel);
        this.pack();
    }

    @Override
    protected String getDialogTitle() {
        return "Color selection";
    }

    @Override
    protected String getDescription() {
        return "Select colors";
    }

    @Override
    protected Component getInputComponentsPane() {
        this.inputComponents = new JPanel(new BorderLayout());
        return this.inputComponents;
    }

    private void checkOkButton() {
        int count = this.getSelectedColors().size();
        this.okButton.setEnabled(count >= this.min && count <= this.max);
    }

    public List<Color> getSelectedColors() {
        return this.colorsListPanel.getSelectedColors();
    }
}

