/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.databinding.CUtils;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CStructWriter
implements BeanWriter {
    public static final String WRAPPED_DATABINDING_CLASS_NAME = "WrappedDatabinder";
    public static final String EXTENSION_MAPPER_CLASSNAME = "extension_mapper";
    public static final String AXIS2_PREFIX = "adb_";
    private String javaBeanTemplateName = null;
    private boolean templateLoaded = false;
    private Templates sourceTemplateCache;
    private Templates headerTemplateCache;
    private List<String> namesList;
    private static int count = 0;
    private boolean wrapClasses = false;
    private boolean writeClasses = false;
    protected File rootDir;
    private Document globalWrappedSourceDocument;
    private Document globalWrappedHeaderDocument;
    private Map modelMap = new HashMap();
    private static final String ADB_CLASS_PREFIX = "adb_";
    private static final String ADB_CLASS_POSTFIX = "_t*";
    private static final String DEFAULT_C_CLASS_NAME = "axiom_node_t*";
    private Map baseTypeMap = new JavaTypeMap().getTypeMap();
    public static final String DEFAULT_CLASS_NAME = "axiom_node_t*";
    public static final String DEFAULT_CLASS_ARRAY_NAME = "axiom_node_t*";
    public static final String DEFAULT_ATTRIB_CLASS_NAME = "axiom_attribute_t*";
    public static final String DEFAULT_ATTRIB_ARRAY_CLASS_NAME = "axiom_attribute_t*";
    public static final String DEFAULT_TYPE_NS = "http://www.w3.org/2001/XMLSchema";
    private int lastPrefixIndex = 1;
    HashMap<String, String> mapURItoPrefix = new HashMap();
    HashMap<String, String> mapPrefixtoURI = new HashMap();

    @Override
    public Map getModelMap() {
        return this.modelMap;
    }

    @Override
    public String getDefaultClassName() {
        return "axiom_node_t*";
    }

    @Override
    public String getDefaultClassArrayName() {
        return "axiom_node_t*";
    }

    @Override
    public String getDefaultAttribClassName() {
        return "axiom_attribute_t*";
    }

    @Override
    public String getDefaultAttribArrayClassName() {
        return "axiom_attribute_t*";
    }

    @Override
    public void init(CompilerOptions options) throws SchemaCompilationException {
        try {
            this.initWithFile(options.getOutputLocation());
            this.writeClasses = options.isWriteOutput();
            this.wrapClasses = !this.writeClasses ? false : options.isWrapClasses();
            if (options.isWrapClasses()) {
                this.globalWrappedSourceDocument = XSLTUtils.getDocument();
                Element rootElement = XSLTUtils.getElement(this.globalWrappedSourceDocument, "beans");
                this.globalWrappedSourceDocument.appendChild(rootElement);
                XSLTUtils.addAttribute(this.globalWrappedSourceDocument, "name", WRAPPED_DATABINDING_CLASS_NAME, rootElement);
                this.globalWrappedHeaderDocument = XSLTUtils.getDocument();
                rootElement = XSLTUtils.getElement(this.globalWrappedHeaderDocument, "beans");
                this.globalWrappedHeaderDocument.appendChild(rootElement);
                XSLTUtils.addAttribute(this.globalWrappedHeaderDocument, "name", WRAPPED_DATABINDING_CLASS_NAME, rootElement);
            }
        }
        catch (IOException e) {
            throw new SchemaCompilationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaElement element, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = element.getQName();
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(QName qName, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf, boolean isAbstract) throws SchemaCompilationException {
        try {
            return this.process(qName, metainf, typeMap, groupTypeMap, false, isAbstract);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public void writeBatch() throws SchemaCompilationException {
        try {
            if (this.wrapClasses) {
                File outSource = this.createOutFile(WRAPPED_DATABINDING_CLASS_NAME, ".c", null);
                File outHeader = this.createOutFile(WRAPPED_DATABINDING_CLASS_NAME, ".h", null);
                this.parseSource(this.globalWrappedSourceDocument, outSource);
                this.parseHeader(this.globalWrappedHeaderDocument, outHeader);
            }
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaSimpleType simpleType, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = simpleType.getQName();
            if (qName == null) {
                qName = (QName)simpleType.getMetaInfoMap().get("Q_NAME");
            }
            metainf.addtStatus(qName, 64);
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    private void initWithFile(File rootDir) throws IOException {
        if (rootDir == null) {
            this.rootDir = new File(".");
        } else {
            if (!rootDir.isDirectory()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.rootnotfolderexception"));
            }
            this.rootDir = rootDir;
        }
        this.namesList = new ArrayList<String>();
        this.javaBeanTemplateName = SchemaPropertyLoader.getBeanTemplate();
    }

    @Override
    public String makeFullyQualifiedClassName(QName qName) {
        String originalName = qName.getLocalPart();
        return this.makeUniqueCStructName(this.namesList, originalName);
    }

    private String process(QName qName, BeanWriterMetaInfoHolder metainf, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isElement, boolean isAbstract) throws Exception {
        String fullyQualifiedClassName = metainf.getOwnClassName();
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.makeFullyQualifiedClassName(qName);
        }
        String className = fullyQualifiedClassName;
        String originalName = qName == null ? "" : qName.getLocalPart();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (!this.templateLoaded) {
            this.loadTemplate();
        }
        if (this.wrapClasses) {
            this.globalWrappedSourceDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedSourceDocument, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            this.globalWrappedHeaderDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedHeaderDocument, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
        } else {
            Document modelSource = XSLTUtils.getDocument();
            Document modelHeader = XSLTUtils.getDocument();
            modelSource.appendChild(this.getBeanElement(modelSource, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            modelHeader.appendChild(this.getBeanElement(modelHeader, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            if (this.writeClasses) {
                String fileName = className.substring(4, className.length() - 3);
                File outSource = this.createOutFile(fileName, ".c", null);
                File outHeader = this.createOutFile(fileName, ".h", null);
                this.parseSource(modelSource, outSource);
                this.parseHeader(modelHeader, outHeader);
            }
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), modelSource);
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), modelHeader);
        }
        return fullyQualifiedClassName;
    }

    private Element getBeanElement(Document model, String className, String originalName, QName qName, boolean isElement, boolean isAbstract, BeanWriterMetaInfoHolder metainf, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) throws SchemaCompilationException {
        Element rootElt = XSLTUtils.getElement(model, "class");
        String strippedClassName = className.substring(4, className.length() - 3);
        XSLTUtils.addAttribute(model, "name", strippedClassName, rootElt);
        XSLTUtils.addAttribute(model, "originalName", originalName, rootElt);
        XSLTUtils.addAttribute(model, "nsuri", qName.getNamespaceURI(), rootElt);
        XSLTUtils.addAttribute(model, "nsprefix", this.getPrefixForURI(qName.getNamespaceURI(), qName.getPrefix()), rootElt);
        String capsName = strippedClassName.toUpperCase();
        XSLTUtils.addAttribute(model, "caps-name", capsName, rootElt);
        if (!this.wrapClasses) {
            XSLTUtils.addAttribute(model, "unwrapped", "yes", rootElt);
        }
        if (isAbstract) {
            XSLTUtils.addAttribute(model, "isAbstract", "yes", rootElt);
        }
        if (!this.writeClasses) {
            XSLTUtils.addAttribute(model, "skip-write", "yes", rootElt);
        }
        if (!isElement) {
            XSLTUtils.addAttribute(model, "type", "yes", rootElt);
        }
        if (metainf.isAnonymous()) {
            XSLTUtils.addAttribute(model, "anon", "yes", rootElt);
        }
        if (metainf.isExtension()) {
            XSLTUtils.addAttribute(model, "extension", metainf.getExtensionClassName(), rootElt);
        }
        if (metainf.isRestriction()) {
            XSLTUtils.addAttribute(model, "restriction", metainf.getRestrictionClassName(), rootElt);
        }
        if (metainf.isChoice()) {
            XSLTUtils.addAttribute(model, "choice", "yes", rootElt);
        }
        if (metainf.isSimple()) {
            XSLTUtils.addAttribute(model, "simple", "yes", rootElt);
        }
        if (metainf.isUnion()) {
            XSLTUtils.addAttribute(model, "union", "yes", rootElt);
        }
        if (metainf.isList()) {
            XSLTUtils.addAttribute(model, "list", "yes", rootElt);
        }
        if (metainf.isOrdered()) {
            XSLTUtils.addAttribute(model, "ordered", "yes", rootElt);
        }
        if (isElement && metainf.isNillable(qName)) {
            XSLTUtils.addAttribute(model, "nillable", "yes", rootElt);
        }
        if (metainf.isParticleClass()) {
            XSLTUtils.addAttribute(model, "particleClass", "yes", rootElt);
        }
        if (metainf.isHasParticleType()) {
            XSLTUtils.addAttribute(model, "hasParticleType", "yes", rootElt);
        }
        this.populateInfo(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, false);
        if (metainf.isSimple() && metainf.isUnion()) {
            this.populateMemberInfo(metainf, model, rootElt, typeMap);
        }
        if (metainf.isSimple() && metainf.isList()) {
            this.populateListInfo(metainf, model, rootElt, typeMap, groupTypeMap);
        }
        return rootElt;
    }

    protected void populateListInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) {
        String cName = this.makeUniqueCStructName(new ArrayList<String>(), metainf.getItemTypeQName().getLocalPart());
        Element itemType = XSLTUtils.addChildElement(model, "itemtype", rootElement);
        XSLTUtils.addAttribute(model, "type", metainf.getItemTypeClassName(), itemType);
        XSLTUtils.addAttribute(model, "nsuri", metainf.getItemTypeQName().getNamespaceURI(), itemType);
        XSLTUtils.addAttribute(model, "originalName", metainf.getItemTypeQName().getLocalPart(), itemType);
        XSLTUtils.addAttribute(model, "cname", cName.substring(4, cName.length() - 3), itemType);
        if (typeMap.containsKey(metainf.getItemTypeQName()) || groupTypeMap.containsKey(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute(model, "ours", "true", itemType);
        }
        if (PrimitiveTypeFinder.isPrimitive(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute(model, "primitive", "yes", itemType);
        }
    }

    protected void populateMemberInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap) {
        Map<QName, String> memberTypes = metainf.getMemberTypes();
        for (QName memberQName : memberTypes.keySet()) {
            String memberClass = memberTypes.get(memberQName);
            Element memberType = XSLTUtils.addChildElement(model, "memberType", rootElement);
            XSLTUtils.addAttribute(model, "type", memberClass, memberType);
            XSLTUtils.addAttribute(model, "nsuri", memberQName.getNamespaceURI(), memberType);
            XSLTUtils.addAttribute(model, "originalName", memberQName.getLocalPart(), memberType);
            XSLTUtils.addAttribute(model, "caps-originalName", memberQName.getLocalPart().toUpperCase(), memberType);
            if (!typeMap.containsKey(memberQName)) continue;
            XSLTUtils.addAttribute(model, "ours", "true", memberType);
        }
    }

    private void populateInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        if (metainf.getParent() != null && (!metainf.isRestriction() || metainf.isRestriction() && metainf.isSimple())) {
            this.populateInfo(metainf.getParent(), model, rootElt, propertyNames, typeMap, groupTypeMap, true);
        }
        this.addPropertyEntries(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, isInherited);
    }

    private void addPropertyEntries(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        ArrayList<QName> missingQNames = new ArrayList<QName>();
        ArrayList<QName> qNames = new ArrayList<QName>();
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        QName[] qName = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int i = 0; i < qName.length; ++i) {
            qNames.add(qName[i]);
        }
        if (metainf.isRestriction() && !metainf.isSimple()) {
            this.addMissingQNames(metainf, qNames, missingQNames);
        }
        for (int i = 0; i < qName.length; ++i) {
            QName schemaQName;
            Element property = XSLTUtils.addChildElement(model, "property", rootElt);
            QName name = qName[i];
            String xmlName = this.makeUniqueCStructName(new ArrayList<String>(), name.getLocalPart());
            XSLTUtils.addAttribute(model, "name", name.getLocalPart(), property);
            XSLTUtils.addAttribute(model, "originalName", name.getLocalPart(), property);
            XSLTUtils.addAttribute(model, "nsuri", name.getNamespaceURI(), property);
            XSLTUtils.addAttribute(model, "prefix", name.getPrefix(), property);
            XSLTUtils.addAttribute(model, "cname", xmlName.substring(4, xmlName.length() - 3), property);
            String CClassNameForElement = metainf.getClassNameForQName(name);
            if (CClassNameForElement == null) {
                CClassNameForElement = "axiom_node_t*";
            }
            CClassNameForElement = this.getShortTypeName(CClassNameForElement);
            XSLTUtils.addAttribute(model, "type", CClassNameForElement, property);
            XSLTUtils.addAttribute(model, "caps-cname", xmlName.substring(4, xmlName.length() - 3).toUpperCase(), property);
            XSLTUtils.addAttribute(model, "caps-type", CClassNameForElement.toUpperCase(), property);
            if (PrimitiveTypeFinder.isPrimitive(CClassNameForElement)) {
                XSLTUtils.addAttribute(model, "primitive", "yes", property);
            }
            if (this.isDefault(CClassNameForElement)) {
                XSLTUtils.addAttribute(model, "default", "yes", property);
            }
            if (metainf.isDefaultValueAvailable(name) && this.baseTypeMap.containsKey(schemaQName = metainf.getSchemaQNameForQName(name))) {
                XSLTUtils.addAttribute(model, "defaultValue", metainf.getDefaultValueForQName(name), property);
            }
            if (typeMap.containsKey(metainf.getSchemaQNameForQName(name)) || (metainf.getSchemaQNameForQName(name) == null || !metainf.getSchemaQNameForQName(name).getNamespaceURI().equals(DEFAULT_TYPE_NS)) && !CClassNameForElement.equals("axiom_node_t*") && !CClassNameForElement.equals("axiom_attribute_t*")) {
                XSLTUtils.addAttribute(model, "ours", "yes", property);
            }
            if (metainf.getAttributeStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "attribute", "yes", property);
            } else {
                XSLTUtils.addAttribute(model, "notattribute", "yes", property);
            }
            if (metainf.isNillable(name)) {
                XSLTUtils.addAttribute(model, "nillable", "yes", property);
            }
            String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(CClassNameForElement)) : this.getShortTypeName(CClassNameForElement);
            XSLTUtils.addAttribute(model, "shorttypename", shortTypeName, property);
            if (isInherited) {
                XSLTUtils.addAttribute(model, "inherited", "yes", property);
            }
            if (metainf.getAnyStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "any", "yes", property);
            }
            if (metainf.getBinaryStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "binary", "yes", property);
            }
            if (metainf.getSimpleStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "simple", "yes", property);
            }
            long minOccurs = metainf.getMinOccurs(name);
            XSLTUtils.addAttribute(model, "minOccurs", minOccurs + "", property);
            if (metainf.getArrayStatusForQName(name)) {
                String attrName = name.getLocalPart();
                int arrayTokenStart = attrName.indexOf("Array");
                if (arrayTokenStart >= 0) {
                    String arrayEle = attrName.substring(0, arrayTokenStart);
                    XSLTUtils.addAttribute(model, "arrayele", arrayEle, property);
                }
                XSLTUtils.addAttribute(model, "isarray", "yes", property);
                XSLTUtils.addAttribute(model, "arrayBaseType", CClassNameForElement, property);
                long maxOccurs = metainf.getMaxOccurs(name);
                if (maxOccurs == Long.MAX_VALUE) {
                    XSLTUtils.addAttribute(model, "unbound", "yes", property);
                }
                XSLTUtils.addAttribute(model, "maxOccurs", maxOccurs + "", property);
            }
            if (parentMetaInf != null && metainf.isRestriction() && missingQNames.contains(name)) {
                this.addAttributesToProperty(parentMetaInf, name, model, property, typeMap, groupTypeMap, CClassNameForElement);
                continue;
            }
            this.addAttributesToProperty(metainf, name, model, property, typeMap, groupTypeMap, CClassNameForElement);
        }
    }

    private void addAttributesToProperty(BeanWriterMetaInfoHolder metainf, QName name, Document model, Element property, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, String CClassNameForElement) {
        if (metainf.getDefaultStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "default", "yes", property);
        }
        if (typeMap.containsKey(metainf.getSchemaQNameForQName(name)) || groupTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) || (metainf.getSchemaQNameForQName(name) == null || !metainf.getSchemaQNameForQName(name).getNamespaceURI().equals(DEFAULT_TYPE_NS)) && !CClassNameForElement.equals("axiom_node_t*") && !CClassNameForElement.equals("axiom_attribute_t*")) {
            XSLTUtils.addAttribute(model, "ours", "yes", property);
        }
        if (metainf.getAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "attribute", "yes", property);
        }
        if (metainf.isNillable(name)) {
            XSLTUtils.addAttribute(model, "nillable", "yes", property);
        }
        if (metainf.getOptionalAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "optional", "yes", property);
        }
        String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(CClassNameForElement)) : this.getShortTypeName(CClassNameForElement);
        XSLTUtils.addAttribute(model, "shorttypename", shortTypeName, property);
        if (metainf.getAnyStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "any", "yes", property);
        }
        if (metainf.getBinaryStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "binary", "yes", property);
        }
        if (metainf.isSimple() || metainf.getSimpleStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "simple", "yes", property);
        }
        long minOccurs = metainf.getMinOccurs(name);
        XSLTUtils.addAttribute(model, "minOccurs", minOccurs + "", property);
        if (metainf.getArrayStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "array", "yes", property);
            int endIndex = CClassNameForElement.indexOf("[");
            if (endIndex >= 0) {
                XSLTUtils.addAttribute(model, "arrayBaseType", CClassNameForElement.substring(0, endIndex), property);
            } else {
                XSLTUtils.addAttribute(model, "arrayBaseType", CClassNameForElement, property);
            }
            long maxOccurs = metainf.getMaxOccurs(name);
            if (maxOccurs == Long.MAX_VALUE) {
                XSLTUtils.addAttribute(model, "unbound", "yes", property);
            } else {
                XSLTUtils.addAttribute(model, "maxOccurs", maxOccurs + "", property);
            }
        }
        if (metainf.isRestrictionBaseType(name)) {
            XSLTUtils.addAttribute(model, "restrictionBaseType", "yes", property);
        }
        if (metainf.isExtensionBaseType(name)) {
            XSLTUtils.addAttribute(model, "extensionBaseType", "yes", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getLengthFacet() != -1L) {
            XSLTUtils.addAttribute(model, "lenFacet", metainf.getLengthFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxLengthFacet() != -1L) {
            XSLTUtils.addAttribute(model, "maxLenFacet", metainf.getMaxLengthFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinLengthFacet() != -1L) {
            XSLTUtils.addAttribute(model, "minLenFacet", metainf.getMinLengthFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getTotalDigitsFacet() != null) {
            XSLTUtils.addAttribute(model, "totalDigitsFacet", metainf.getTotalDigitsFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxExclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "maxExFacet", metainf.getMaxExclusiveFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinExclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "minExFacet", metainf.getMinExclusiveFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxInclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "maxInFacet", metainf.getMaxInclusiveFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinInclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "minInFacet", metainf.getMinInclusiveFacet() + "", property);
        }
        if (!metainf.getEnumFacet().isEmpty()) {
            boolean validJava = true;
            for (String value : metainf.getEnumFacet()) {
                if (JavaUtils.isJavaId(value)) continue;
                validJava = false;
            }
            int id = 0;
            for (String attribValue : metainf.getEnumFacet()) {
                Element enumFacet = XSLTUtils.addChildElement(model, "enumFacet", property);
                XSLTUtils.addAttribute(model, "value", attribValue, enumFacet);
                if (validJava) {
                    XSLTUtils.addAttribute(model, "id", attribValue.toUpperCase(), enumFacet);
                    continue;
                }
                XSLTUtils.addAttribute(model, "id", attribValue.toUpperCase().replaceAll("[^A-Z0-9]", "_") + "_" + ++id, enumFacet);
            }
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getPatternFacet() != null) {
            XSLTUtils.addAttribute(model, "patternFacet", metainf.getPatternFacet(), property);
        }
    }

    private void addMissingQNames(BeanWriterMetaInfoHolder metainf, ArrayList<QName> qName, ArrayList<QName> missingQNames) {
        int i;
        QName[] qNames = null;
        QName[] pQNames = null;
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        if (parentMetaInf != null) {
            pQNames = parentMetaInf.isOrdered() ? parentMetaInf.getOrderedQNameArray() : parentMetaInf.getQNameArray();
        }
        for (i = 0; pQNames != null && i < pQNames.length; ++i) {
            if (!this.qNameNotFound(pQNames[i], metainf)) continue;
            missingQNames.add(pQNames[i]);
        }
        if (!missingQNames.isEmpty()) {
            for (i = 0; i < missingQNames.size(); ++i) {
                qName.add(missingQNames.get(i));
            }
        }
    }

    private boolean qNameNotFound(QName qname, BeanWriterMetaInfoHolder metainf) {
        boolean found = false;
        QName[] qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int j = 0; j < qNames.length; ++j) {
            if (!qname.getLocalPart().equals(qNames[j].getLocalPart())) continue;
            found = true;
        }
        return !found;
    }

    private boolean isDefault(String CClassNameForElement) {
        return this.getDefaultClassName().equals(CClassNameForElement) || this.getDefaultClassArrayName().equals(CClassNameForElement);
    }

    private String makeUniqueCStructName(List<String> listOfNames, String xmlName) {
        String cName = CUtils.isCKeyword(xmlName) ? CUtils.makeNonCKeyword(xmlName) : xmlName;
        cName = cName.replace('.', '_');
        cName = cName.replace('-', '_');
        while (listOfNames.contains(cName.toLowerCase())) {
            cName = !listOfNames.contains((cName + "E").toLowerCase()) ? cName + "E" : cName + count++;
            cName = cName + count++;
        }
        listOfNames.add(cName.toLowerCase());
        String modifiedCName = "adb_" + cName + ADB_CLASS_POSTFIX;
        return modifiedCName;
    }

    private void loadTemplate() throws SchemaCompilationException {
        Class<?> clazz = this.getClass();
        String templateName = this.javaBeanTemplateName;
        if (templateName != null) {
            try {
                String sourceTemplateName = templateName + "Source.xsl";
                InputStream xslStream = clazz.getResourceAsStream(sourceTemplateName);
                this.sourceTemplateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                String headerTemplateName = templateName + "Header.xsl";
                xslStream = clazz.getResourceAsStream(headerTemplateName);
                this.headerTemplateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                this.templateLoaded = true;
            }
            catch (TransformerConfigurationException e) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateLoadException"), e);
            }
        } else {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateNotFoundException"));
        }
    }

    protected File createOutFile(String fileName, String extension, String prefix) throws Exception {
        return FileWriter.createClassFile(this.rootDir, "", (prefix == null ? "adb_" : prefix) + fileName, extension);
    }

    private void parseSource(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, doc, this.sourceTemplateCache.newTransformer());
        ((OutputStream)outStream).write(10);
        ((OutputStream)outStream).write(10);
        outStream.flush();
        ((OutputStream)outStream).close();
    }

    private void parseHeader(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, doc, this.headerTemplateCache.newTransformer());
        ((OutputStream)outStream).write(10);
        ((OutputStream)outStream).write(10);
        outStream.flush();
        ((OutputStream)outStream).close();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.mapURItoPrefix.get(uri);
        if (prefix == null) {
            if (defaultPrefix == null || defaultPrefix.length() == 0) {
                prefix = "ns" + this.lastPrefixIndex++;
                while (this.mapPrefixtoURI.get(prefix) != null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                }
            } else {
                prefix = defaultPrefix;
            }
            this.mapPrefixtoURI.put(prefix, uri);
            this.mapURItoPrefix.put(uri, prefix);
        }
        return prefix;
    }

    private String getShortTypeName(String typeClassName) {
        if (typeClassName.endsWith("[]")) {
            typeClassName = typeClassName.substring(0, typeClassName.lastIndexOf("["));
        }
        return typeClassName;
    }

    @Override
    public void registerExtensionMapperPackageName(String mapperPackageName) {
    }

    @Override
    public void writeExtensionMapper(BeanWriterMetaInfoHolder[] metainfArray) throws SchemaCompilationException {
        try {
            Document model = XSLTUtils.getDocument();
            Element rootElt = XSLTUtils.getElement(model, "mapper");
            Element rootElt2 = XSLTUtils.getElement(model, "mapper");
            String extMapperName = EXTENSION_MAPPER_CLASSNAME;
            if (!this.wrapClasses) {
                XSLTUtils.addAttribute(model, "unwrapped", "yes", rootElt);
            }
            if (!this.writeClasses) {
                XSLTUtils.addAttribute(model, "skip-write", "yes", rootElt);
            }
            for (BeanWriterMetaInfoHolder metainf : metainfArray) {
                QName ownQname = metainf.getOwnQname();
                String className = metainf.getOwnClassName();
                if (ownQname == null) continue;
                Element typeChild = XSLTUtils.addChildElement(model, "type", rootElt);
                XSLTUtils.addAttribute(model, "nsuri", ownQname.getNamespaceURI(), typeChild);
                XSLTUtils.addAttribute(model, "classname", className == null ? "" : className, typeChild);
                XSLTUtils.addAttribute(model, "shortname", ownQname == null ? "" : ownQname.getLocalPart(), typeChild);
            }
            model.appendChild(rootElt);
            if (!this.templateLoaded) {
                this.loadTemplate();
            }
            if (this.wrapClasses) {
                rootElt2 = (Element)this.globalWrappedSourceDocument.importNode(rootElt, true);
                this.globalWrappedSourceDocument.getDocumentElement().appendChild(rootElt2);
                XSLTUtils.addAttribute(this.globalWrappedSourceDocument, "name", extMapperName, rootElt2);
                XSLTUtils.addAttribute(this.globalWrappedSourceDocument, "caps-name", extMapperName.toUpperCase(), rootElt2);
                rootElt2 = (Element)this.globalWrappedHeaderDocument.importNode(rootElt, true);
                this.globalWrappedHeaderDocument.getDocumentElement().appendChild(rootElt2);
                XSLTUtils.addAttribute(this.globalWrappedHeaderDocument, "name", extMapperName, rootElt2);
                XSLTUtils.addAttribute(this.globalWrappedHeaderDocument, "caps-name", extMapperName.toUpperCase(), rootElt2);
            } else {
                XSLTUtils.addAttribute(model, "name", extMapperName, model.getDocumentElement());
                XSLTUtils.addAttribute(model, "caps-name", extMapperName.toUpperCase(), rootElt);
                if (this.writeClasses) {
                    File outSource = this.createOutFile(extMapperName, ".c", "axis2_");
                    File outHeader = this.createOutFile(extMapperName, ".h", "axis2_");
                    this.parseSource(model, outSource);
                    this.parseHeader(model, outHeader);
                }
                this.modelMap.put(new QName(extMapperName), model);
                this.modelMap.put(new QName(extMapperName), model);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.document.error"), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String getExtensionMapperPackageName() {
        return null;
    }
}

