/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.PatternFilteringSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class ReallocateReferenceSequencesTransformation
implements SequencesGroupTransformation {
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private PatternFilteringSequencesGroupTransformation filter;

    public ReallocateReferenceSequencesTransformation(EvaluableSequencePattern pattern, SequenceTranslationConfiguration configuration) {
        this(pattern, configuration, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public ReallocateReferenceSequencesTransformation(EvaluableSequencePattern pattern, SequenceTranslationConfiguration configuration, DatatypeFactory factory) {
        this.filter = new PatternFilteringSequencesGroupTransformation(pattern, configuration);
    }

    public ReallocateReferenceSequencesTransformation(EvaluableSequencePattern pattern, SequenceTarget sequenceTarget) {
        this(pattern, sequenceTarget, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public ReallocateReferenceSequencesTransformation(EvaluableSequencePattern pattern, SequenceTarget sequenceTarget, DatatypeFactory factory) {
        this.filter = new PatternFilteringSequencesGroupTransformation(pattern, sequenceTarget);
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        try {
            List referenceSequences = this.filter.transform(sequencesGroup).getSequences().collect(Collectors.toList());
            LinkedList<Sequence> newSequences = new LinkedList<Sequence>(referenceSequences);
            newSequences.addAll(sequencesGroup.getSequences().filter(s -> !referenceSequences.contains(s)).collect(Collectors.toList()));
            return this.builder.of(sequencesGroup.getName(), sequencesGroup.getProperties(), newSequences);
        }
        catch (TransformationException ex) {
            return sequencesGroup;
        }
    }
}

