/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import org.sing_group.seda.bio.SequenceUtils;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.FilterSequencesGroupTransformation;

public class FilterByStartCodonTransformation
extends FilterSequencesGroupTransformation {
    public FilterByStartCodonTransformation(String[] validStartCodons) {
        this(validStartCodons, false);
    }

    public FilterByStartCodonTransformation(String[] validStartCodons, boolean checkGeneSequence) {
        this(Arrays.asList(validStartCodons), checkGeneSequence);
    }

    public FilterByStartCodonTransformation(Collection<String> validStartCodons) {
        this(validStartCodons, false);
    }

    public FilterByStartCodonTransformation(Collection<String> validStartCodons, boolean checkGeneSequence) {
        super(FilterByStartCodonTransformation.buildPredicate(validStartCodons, checkGeneSequence));
    }

    public FilterByStartCodonTransformation(String[] validStartCodons, DatatypeFactory factory) {
        this(Arrays.asList(validStartCodons), false, factory);
    }

    public FilterByStartCodonTransformation(String[] validStartCodons, boolean checkGeneSequence, DatatypeFactory factory) {
        this(Arrays.asList(validStartCodons), checkGeneSequence, factory);
    }

    public FilterByStartCodonTransformation(Collection<String> validStartCodons, DatatypeFactory factory) {
        this(validStartCodons, false, factory);
    }

    public FilterByStartCodonTransformation(Collection<String> validStartCodons, boolean checkGeneSequence, DatatypeFactory factory) {
        super(FilterByStartCodonTransformation.buildPredicate(validStartCodons, checkGeneSequence), factory);
    }

    private static final Predicate<Sequence> buildPredicate(Collection<String> validStartCodons, boolean checkGeneSequence) {
        HashSet<String> validStartCodonsSet = new HashSet<String>(validStartCodons);
        return sequence -> {
            String startCodon = SequenceUtils.toCodons(sequence, true, checkGeneSequence).findFirst().orElseThrow(() -> new TransformationException("Invalid sequence: " + sequence.getChain()));
            return validStartCodonsSet.contains(startCodon);
        };
    }
}

