/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequence;

import java.util.Map;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.transformation.sequence.SequenceTransformation;

public class ReplaceCharactersSequenceTransformation
implements SequenceTransformation {
    private final SequenceBuilder builder = factory::newSequence;
    private final Map<String, String> replacements;

    public ReplaceCharactersSequenceTransformation(Map<String, String> replacements) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), replacements);
    }

    public ReplaceCharactersSequenceTransformation(DatatypeFactory factory, Map<String, String> replacements) {
        this.replacements = replacements;
    }

    @Override
    public Sequence transform(Sequence sequence) {
        String chain = sequence.getChain();
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            chain = chain.replace(entry.getKey(), entry.getValue());
        }
        return this.builder.of(sequence.getName(), sequence.getDescription(), chain, sequence.getProperties());
    }
}

