/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sing_group.seda.bio.SequenceUtils;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class TranslateSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private final SequencesGroupBuilder groupBuilder = factory::newSequencesGroup;
    private final SequenceBuilder sequenceBuilder = factory::newSequence;
    private final SequenceTranslationConfiguration configuration;

    public TranslateSequencesGroupDatasetTransformation(SequenceTranslationConfiguration configuration) {
        this(configuration, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public TranslateSequencesGroupDatasetTransformation(SequenceTranslationConfiguration configuration, DatatypeFactory factory) {
        this.configuration = configuration;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) {
        List<SequencesGroup> sequencesGroups = dataset.getSequencesGroups().map(this::translateSequencesGroup).flatMap(Collection::stream).collect(Collectors.toList());
        if (sequencesGroups.size() == 0) {
            throw new TransformationException("No sequences after filtering");
        }
        return this.builder.apply(sequencesGroups.toArray(new SequencesGroup[sequencesGroups.size()]));
    }

    private List<SequencesGroup> translateSequencesGroup(SequencesGroup group) {
        boolean appendFrameName = this.configuration.getFrames().size() > 1;
        LinkedList<SequencesGroup> translatedSequenceGroups = new LinkedList<SequencesGroup>();
        for (int frame : this.configuration.getFrames()) {
            String newGroupName = group.getName();
            if (appendFrameName) {
                newGroupName = newGroupName + "_frame_" + frame;
            }
            translatedSequenceGroups.add(this.translateGroup(newGroupName, group, frame));
        }
        return translatedSequenceGroups;
    }

    private SequencesGroup translateGroup(String newGroupName, SequencesGroup group, int frame) {
        return this.groupBuilder.of(newGroupName, group.getProperties(), group.getSequences().map(s -> this.sequenceBuilder.of(s.getName(), s.getDescription(), SequenceUtils.translate(s.getChain(), this.configuration.isReverseComplement(), frame, this.configuration.getCodonTable()), s.getProperties())).collect(Collectors.toList()));
    }
}

