/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.sing_group.seda.bio.FunctionUtil;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class ComposedSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private final Function<SequencesGroup[], SequencesGroupDataset> builder = factory::newSequencesGroupDataset;
    private final SequencesGroupTransformation[] transformations;

    public ComposedSequencesGroupDatasetTransformation(SequencesGroupTransformation ... transformations) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), transformations);
    }

    public ComposedSequencesGroupDatasetTransformation(DatatypeFactory factory, SequencesGroupTransformation ... transformations) {
        this.transformations = transformations;
    }

    public ComposedSequencesGroupDatasetTransformation(Collection<SequencesGroupTransformation> transformations) {
        this((SequencesGroupTransformation[])transformations.stream().toArray(SequencesGroupTransformation[]::new));
    }

    public ComposedSequencesGroupDatasetTransformation(DatatypeFactory factory, Collection<SequencesGroupTransformation> transformations) {
        this(factory, (SequencesGroupTransformation[])transformations.stream().toArray(SequencesGroupTransformation[]::new));
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) throws TransformationException {
        Stream<SequencesGroup> sequencesGroupsStream = (Stream<SequencesGroup>)dataset.getSequencesGroups().parallel();
        for (SequencesGroupTransformation transformation : this.transformations) {
            sequencesGroupsStream = sequencesGroupsStream.map(FunctionUtil.wrapWithExceptionToNull(g -> transformation.transform((SequencesGroup)g), (g, e) -> {
                System.err.println("An exception occurred processing " + g.getName());
                System.err.println("Exception message: " + e.getMessage());
                if (e.getCause() != null) {
                    System.err.println("Exception message: " + e.getCause().getMessage());
                }
                System.err.println();
            })).filter(Objects::nonNull);
        }
        SequencesGroup[] sequencesGroups = (SequencesGroup[])sequencesGroupsStream.toArray(SequencesGroup[]::new);
        if (sequencesGroups.length == 0) {
            throw new TransformationException("No files after filtering");
        }
        return this.builder.apply(sequencesGroups);
    }
}

