/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.info;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class AbstractInfo {
    public static final String PARAM_DOCKER_MODE_NAME = "docker-mode";
    public static final String PARAM_DOCKER_MODE_SHORT_NAME = "dk";
    public static final String PARAM_DOCKER_MODE_DESCRIPTION = "Uses a docker image to execute the transformation";
    public static final String PARAM_LOCAL_MODE_NAME = "local-mode";
    public static final String PARAM_LOCAL_MODE_SHORT_NAME = "lc";
    public static final String PARAM_LOCAL_MODE_DESCRIPTION = "Uses a local binary to execute the transformation";

    public static String toHtml(String plainHelp) {
        return AbstractInfo.toHtml(plainHelp, true);
    }

    public static String toHtml(String plainHelp, boolean addLineBreakOnStops) {
        return AbstractInfo.toHtml(plainHelp, Collections.emptyList(), Collections.emptyList(), addLineBreakOnStops);
    }

    public static String toHtml(String plainHelp, List<String> boldWords, List<String> italicWords, boolean addLineBreakOnStops) {
        for (String word : boldWords) {
            plainHelp = plainHelp.replace(word, AbstractInfo.wrapHtmlTag("b", word));
        }
        for (String word : italicWords) {
            plainHelp = plainHelp.replace(word, AbstractInfo.wrapHtmlTag("i", word));
        }
        plainHelp = plainHelp.replace("\n", "<br/><br/>");
        plainHelp = plainHelp.replace("\t", "");
        if (addLineBreakOnStops) {
            plainHelp = plainHelp.replace(". ", ".<br/><br/>");
        }
        return AbstractInfo.wrapHtmlTag("html", plainHelp);
    }

    private static String wrapHtmlTag(String tag, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(tag).append(">").append(text).append("</").append(tag).append(">");
        return sb.toString();
    }

    public static <E extends Enum<E>> String shortEnumString(String description, Class<E> clazz) {
        StringBuilder sb = new StringBuilder(description);
        sb.append(EnumSet.allOf(clazz).stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ", " One of: ", ".")));
        return sb.toString();
    }

    public static String longEnumStringForCli(String description, Map<String, String> enumDescriptions) {
        StringBuilder sb = new StringBuilder(description);
        sb.append(" It can be one of: \n");
        enumDescriptions.forEach((k, v) -> sb.append("\t- ").append((String)k).append(": ").append((String)v).append("\n"));
        return sb.toString();
    }

    public static String longEnumStringForGui(String description, Map<String, String> enumDescriptions) {
        StringBuilder sb = new StringBuilder();
        sb.append(description).append(" It can be one of: <br/><ul>");
        enumDescriptions.forEach((k, v) -> sb.append("<li>").append((String)k).append(": ").append((String)v).append("</li>"));
        sb.append("</ul>");
        return sb.toString();
    }

    public static <E extends Enum<E>> Map<String, String> cliMap(E[] constants, String ... strings) {
        HashMap<String, String> toret = new HashMap<String, String>();
        for (int i = 0; i < constants.length; ++i) {
            toret.put(((Enum)constants[i]).name().toLowerCase(), strings[i]);
        }
        return toret;
    }

    public static <E extends Enum<E>> Map<String, String> guiMap(E[] constants, String ... strings) {
        TreeMap<String, String> toret = new TreeMap<String, String>();
        for (int i = 0; i < constants.length; ++i) {
            toret.put(((Enum)constants[i]).toString(), strings[i]);
        }
        return toret;
    }

    public static String itemsListToCliString(List<String> items, String initialText) {
        StringBuilder sb = new StringBuilder(initialText);
        sb.append('\n');
        items.forEach(i -> sb.append("\t- ").append((String)i).append("\n"));
        return sb.toString();
    }

    public static String itemsListToGuiString(List<String> items, String initialText) {
        StringBuilder sb = new StringBuilder(initialText);
        sb.append("<ul>");
        items.forEach(i -> sb.append("<li>").append((String)i).append("</li>"));
        sb.append("</ul>");
        return sb.toString();
    }
}

