/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.execution;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.utilities.builder.JButtonBuilder;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public abstract class AbstractSystemBinaryExecutionConfigurationPanel<T>
extends JPanel
implements BinaryExecutionConfigurationPanel<T> {
    private static final long serialVersionUID = 1L;
    private SelectionMode selectionMode;
    private JButton checkPathButton;
    private JFileChooserPanel binaryPath;

    public AbstractSystemBinaryExecutionConfigurationPanel(SelectionMode selectionMode, String selectionLabel, String helpTooltip) {
        this.selectionMode = selectionMode;
        this.binaryPath = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(selectionMode).withLabel(selectionLabel).build();
        this.binaryPath.addFileChooserListener(this::binaryPathChanged);
        this.checkPathButton = JButtonBuilder.newJButtonBuilder().thatDoes(this.getCheckBinaryPathAction()).build();
        JLabel helpLabel = new JLabel(Icons.ICON_INFO_2_16);
        helpLabel.setToolTipText(helpTooltip);
        this.setLayout(new FlowLayout());
        this.add((Component)this.binaryPath);
        this.add(helpLabel);
        this.add(this.checkPathButton);
    }

    protected Action getCheckBinaryPathAction() {
        return new ExtendedAbstractAction("Check binary", this::checkBinaryPath);
    }

    private void checkBinaryPath() {
        this.binaryPathChanged(new ChangeEvent(this));
    }

    private void binaryPathChanged(ChangeEvent event) {
        SwingUtilities.invokeLater(() -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.checkBinary();
            this.fireBinariesExecutorChanged();
            this.setCursor(Cursor.getDefaultCursor());
        });
    }

    private void fireBinariesExecutorChanged() {
        for (BinaryConfigurationPanelListener<T> listener : this.getBinaryConfigurationPanelListeners()) {
            listener.onBinariesExecutorChanged(this);
        }
    }

    protected abstract void checkBinary();

    protected File getSelectedBinaryPath() {
        if (this.binaryPath.getSelectedFile() != null) {
            return this.binaryPath.getSelectedFile();
        }
        return null;
    }

    protected Component getParentForDialogs() {
        return SwingUtilities.getRootPane(this);
    }

    @Override
    public synchronized void addBinaryConfigurationPanelListener(BinaryConfigurationPanelListener<T> l) {
        this.listenerList.add(BinaryConfigurationPanelListener.class, l);
    }

    @Override
    public synchronized BinaryConfigurationPanelListener<T>[] getBinaryConfigurationPanelListeners() {
        BinaryConfigurationPanelListener[] listeners = (BinaryConfigurationPanelListener[])this.listenerList.getListeners(BinaryConfigurationPanelListener.class);
        return listeners;
    }

    public void setSelectedFile(File selectedFile) {
        if (selectedFile.isFile() && this.acceptsFiles() || selectedFile.isDirectory() && this.acceptsDirectories()) {
            this.binaryPath.setSelectedFile(selectedFile);
        }
    }

    public void clearSelectedFile() {
        this.binaryPath.clearSelectedFile();
    }

    private boolean acceptsFiles() {
        return this.selectionMode.equals((Object)SelectionMode.FILES) || this.selectionMode.equals((Object)SelectionMode.FILES_DIRECTORIES);
    }

    private boolean acceptsDirectories() {
        return this.selectionMode.equals((Object)SelectionMode.DIRECTORIES) || this.selectionMode.equals((Object)SelectionMode.FILES_DIRECTORIES);
    }
}

