/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.translation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationConfigurationPanel;

public class SequenceTranslationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String INFO_LABEL = "<html>Check this option to show the sequence translation configuration.</html>";
    public static final String PROPERTY_TRANSLATION = "seda.sequencetranslationpanel.translation";
    public static final String PROPERTY_JOIN_FRAMES = "seda.sequencetranslationpanel.joinframes";
    public static final String PROPERTY_FRAMES = "seda.sequencetranslationpanel.frames";
    public static final String PROPERTY_CODON_TABLE = "seda.sequencetranslationpanel.codontable";
    public static final String PROPERTY_REVERSE_SEQUENCES = "seda.sequencetranslationpanel.reversesequences";
    private String checkBoxLabel;
    private String checkBoxTooltip;
    private boolean showJoinFramesCheckbox;
    private JCheckBox convertCb;
    private JXTaskPane translationConfigurationTaskPane;
    private SequenceTranslationConfigurationPanel translationConfigurationPanel;

    public SequenceTranslationPanel() {
        this("Convert to amino acid sequence", INFO_LABEL, true);
    }

    public SequenceTranslationPanel(String checkBoxLabel, String checkBoxTooltip, boolean showJoinFramesCheckbox) {
        this.checkBoxLabel = checkBoxLabel;
        this.checkBoxTooltip = checkBoxTooltip;
        this.showJoinFramesCheckbox = showJoinFramesCheckbox;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getConversionCheckPanel(), "North");
        this.add((Component)this.getConversionConfigurationPanelContainer(), "Center");
        this.convertCb.doClick();
    }

    private JPanel getConversionCheckPanel() {
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 0));
        this.convertCb = new JCheckBox(this.checkBoxLabel, true);
        checkPanel.add(this.convertCb);
        this.convertCb.addItemListener(this::conversionStatusChanged);
        JLabel convertInfoLabel = new JLabel(Icons.ICON_INFO_2_16);
        convertInfoLabel.setToolTipText(this.checkBoxTooltip);
        checkPanel.add(Box.createHorizontalStrut(2));
        checkPanel.add(convertInfoLabel);
        return checkPanel;
    }

    private JPanel getConversionConfigurationPanelContainer() {
        JXTaskPaneContainer customOptionsTaskPaneContainer = new JXTaskPaneContainer();
        customOptionsTaskPaneContainer.setOpaque(false);
        customOptionsTaskPaneContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.translationConfigurationTaskPane = new JXTaskPane();
        this.translationConfigurationTaskPane.setTitle("Translation configuration");
        this.translationConfigurationTaskPane.add((Component)this.getConversionConfigurationPanel());
        this.translationConfigurationTaskPane.setCollapsed(true);
        customOptionsTaskPaneContainer.add((Component)this.translationConfigurationTaskPane);
        return customOptionsTaskPaneContainer;
    }

    private JPanel getConversionConfigurationPanel() {
        this.translationConfigurationPanel = new SequenceTranslationConfigurationPanel(this.showJoinFramesCheckbox);
        this.translationConfigurationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Configuration"));
        return this.translationConfigurationPanel;
    }

    private void conversionStatusChanged(ItemEvent event) {
        this.updateControlsStatus();
        this.firePropertyChange(PROPERTY_TRANSLATION, null, (Object)this.convertCb.isSelected());
    }

    private void updateControlsStatus() {
        boolean enabled = this.convertCb.isSelected() && this.convertCb.isEnabled();
        this.translationConfigurationPanel.enableControls(enabled);
        this.translationConfigurationTaskPane.setCollapsed(!enabled);
    }

    public boolean isTranslationSelected() {
        return this.convertCb.isSelected();
    }

    public boolean isValidUserSelection() {
        return !this.isTranslationSelected() || this.translationConfigurationPanel.isValidUserSelection();
    }

    public void setConversionEnabled(boolean enabled) {
        this.convertCb.setEnabled(enabled);
        this.updateControlsStatus();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.translationConfigurationPanel != null) {
            this.translationConfigurationPanel.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        if (this.translationConfigurationPanel != null) {
            this.translationConfigurationPanel.addPropertyChangeListener(propertyName, listener);
        }
    }

    public SequenceTranslationConfiguration getSequenceTranslationConfiguration() {
        return this.translationConfigurationPanel.getSequenceTranslationConfiguration();
    }

    public void setSequenceTranslationConfiguration(Optional<SequenceTranslationConfiguration> configuration) {
        this.convertCb.setSelected(configuration.isPresent());
        if (configuration.isPresent()) {
            this.translationConfigurationPanel.setSequenceTranslationConfiguration(configuration.get());
        }
    }
}

