/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.split;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.core.split.SequencesGroupSplitMode;
import org.sing_group.seda.plugin.core.info.plugin.SplitSedaPluginInfo;
import org.sing_group.seda.transformation.provider.split.SplitConfigurationTransformationProvider;

public class SplitConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SplitConfigurationTransformationProvider transformationProvider;
    private RadioButtonsPanel<SequencesGroupSplitMode> splitModePanel;
    private JCheckBox randomize;
    private JIntegerTextField randomSeedTf;
    private JCheckBox independentExtractions;
    private JIntegerTextField numFilesTf;
    private JIntegerTextField numSequencesTf;

    public SplitConfigurationPanel() {
        this.init();
        this.transformationProvider = new SplitConfigurationTransformationProvider((SequencesGroupSplitMode)((Object)this.splitModePanel.getSelectedItem().get()), this.randomize.isSelected(), this.randomSeedTf.getValue(), this.independentExtractions.isSelected(), this.numFilesTf.getValue(), this.numSequencesTf.getValue());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.checkTextFieldsStatus();
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getRandomizeParameter());
        parameters.add(this.getRandomSeedParameter());
        parameters.add(this.getSplitModeParameter());
        parameters.add(this.getNumFilesParameter());
        parameters.add(this.getNumSequencesParameter());
        parameters.add(this.getIndependentExtractionsParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getSplitModeParameter() {
        this.splitModePanel = new RadioButtonsPanel((Object[])SequencesGroupSplitMode.values(), SequencesGroupSplitMode.values().length, 1);
        this.splitModePanel.addItemListener(this::splitModeChanged);
        return new InputParameter("Split mode:", this.splitModePanel, SplitSedaPluginInfo.PARAM_SPLIT_MODE_HELP_GUI);
    }

    private void splitModeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.transformationProvider.setSplitMode((SequencesGroupSplitMode)((Object)this.splitModePanel.getSelectedItem().get()));
            this.checkTextFieldsStatus();
        }
    }

    private void checkTextFieldsStatus() {
        switch ((SequencesGroupSplitMode)((Object)this.splitModePanel.getSelectedItem().get())) {
            case FIXED_FILES: {
                this.independentExtractions.setEnabled(false);
                this.numFilesTf.setEditable(true);
                this.numFilesTf.setEnabled(true);
                this.numSequencesTf.setEditable(false);
                this.numSequencesTf.setEnabled(false);
                break;
            }
            case FIXED_SEQUENCES_PER_FILE: {
                this.independentExtractions.setEnabled(false);
                this.numFilesTf.setEditable(false);
                this.numFilesTf.setEnabled(false);
                this.numSequencesTf.setEditable(true);
                this.numSequencesTf.setEnabled(true);
                break;
            }
            case SEQUENCES_PER_FILE_AND_FILES: {
                this.independentExtractions.setEnabled(true);
                this.numFilesTf.setEditable(true);
                this.numFilesTf.setEnabled(true);
                this.numSequencesTf.setEditable(true);
                this.numSequencesTf.setEnabled(true);
                break;
            }
        }
    }

    private InputParameter getRandomizeParameter() {
        this.randomize = new JCheckBox("Randomize", false);
        this.randomize.addItemListener(this::randomizeChanged);
        return new InputParameter("", (JComponent)this.randomize, SplitSedaPluginInfo.PARAM_RANDOMIZE_HELP_GUI);
    }

    private void randomizeChanged(ItemEvent event) {
        this.transformationProvider.setRandomize(this.randomize.isSelected());
        this.randomSeedTf.setEnabled(event.getStateChange() == 1);
    }

    private InputParameter getRandomSeedParameter() {
        this.randomSeedTf = new JIntegerTextField(Integer.valueOf(1));
        this.randomSeedTf.setEnabled(this.randomize.isSelected());
        this.randomSeedTf.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::randomSeedChanged));
        return new InputParameter("Seed:", (JComponent)this.randomSeedTf, SplitSedaPluginInfo.PARAM_SEED_HELP_GUI);
    }

    private void randomSeedChanged() {
        this.transformationProvider.setRandomSeed(this.randomSeedTf.getValue());
    }

    private InputParameter getNumFilesParameter() {
        this.numFilesTf = new JIntegerTextField(Integer.valueOf(1));
        this.numFilesTf.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::numFilesChanged));
        return new InputParameter("Number of files", (JComponent)this.numFilesTf, SplitSedaPluginInfo.PARAM_NUM_FILES_HELP_GUI);
    }

    private void numFilesChanged() {
        this.transformationProvider.numFiles(this.numFilesTf.getValue());
    }

    private InputParameter getNumSequencesParameter() {
        this.numSequencesTf = new JIntegerTextField(Integer.valueOf(1));
        this.numSequencesTf.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::numSequencesChanged));
        return new InputParameter("Number of sequences", (JComponent)this.numSequencesTf, SplitSedaPluginInfo.PARAM_NUM_SEQUENCES_HELP_GUI);
    }

    private void numSequencesChanged() {
        this.transformationProvider.setNumSequences(this.numSequencesTf.getValue());
    }

    private InputParameter getIndependentExtractionsParameter() {
        this.independentExtractions = new JCheckBox("Independent extractions", false);
        this.independentExtractions.addItemListener(this::independentExtractionsChanged);
        return new InputParameter("", (JComponent)this.independentExtractions, SplitSedaPluginInfo.PARAM_INDEPENDENT_EXTRACTIONS_HELP_GUI);
    }

    private void independentExtractionsChanged(ItemEvent event) {
        this.transformationProvider.setIndependentExtractions(this.independentExtractions.isSelected());
    }

    public SplitConfigurationTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(SplitConfigurationTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.randomize.setSelected(this.transformationProvider.isRandomize());
        this.randomSeedTf.setValue((Object)this.transformationProvider.getRandomSeed());
        if (this.transformationProvider.getSplitMode() != null) {
            this.splitModePanel.setSelectedItem((Object)this.transformationProvider.getSplitMode());
        }
        this.numFilesTf.setValue((Object)this.transformationProvider.getNumFiles());
        this.numSequencesTf.setValue((Object)this.transformationProvider.getNumSequences());
        this.independentExtractions.setSelected(this.transformationProvider.isIndependentExtractions());
    }
}

