/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.rename;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.seda.core.rename.FieldSplitRenamer;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.gui.configuration_panel.rename.AbstractRenameHeaderPanel;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderMultipartSedaPluginInfo;

public class FieldSplitRenamePanel
extends AbstractRenameHeaderPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_FIELDS = "<html>The comma-separated list of fields starting at 1.<br>Note that when the <i>Keep</i> mode is used, then the order of the fields is preserved in the output, meaning that it is possible to swap fields.";
    private JXTextField fieldDelimiterTextField;
    private JXTextField joinDelimiterTextField;
    private RadioButtonsPanel<FieldSplitRenamer.Mode> modeRbtnPanel;
    private JXTextField fieldsTextField;

    public FieldSplitRenamePanel() {
        this.init();
    }

    private void init() {
        this.add((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] toret = new InputParameter[]{this.getFieldDelimiterParameter(), this.getJoinDelimiterParameter(), this.getModeParameter(), this.getFieldsParameter()};
        return toret;
    }

    private InputParameter getFieldDelimiterParameter() {
        this.fieldDelimiterTextField = new JXTextField("Field delimiter");
        this.fieldDelimiterTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Field delimiter", (JComponent)this.fieldDelimiterTextField, RenameHeaderMultipartSedaPluginInfo.PARAM_FIELD_DELIMITER_HELP_GUI);
    }

    private InputParameter getJoinDelimiterParameter() {
        this.joinDelimiterTextField = new JXTextField("Join delimiter");
        this.joinDelimiterTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Join delimiter", (JComponent)this.joinDelimiterTextField, RenameHeaderMultipartSedaPluginInfo.PARAM_JOIN_DELIMITER_HELP_GUI);
    }

    private InputParameter getModeParameter() {
        this.modeRbtnPanel = new RadioButtonsPanel((Object[])FieldSplitRenamer.Mode.values(), 1, 2);
        this.modeRbtnPanel.addItemListener(this::modeValueChanged);
        return new InputParameter("Mode", this.modeRbtnPanel, RenameHeaderMultipartSedaPluginInfo.PARAM_FIELD_MODE_HELP_GUI);
    }

    private void modeValueChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.renameConfigurationChanged();
        }
    }

    private InputParameter getFieldsParameter() {
        this.fieldsTextField = new JXTextField("1, 2, 3");
        this.fieldsTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Fields", (JComponent)this.fieldsTextField, HELP_FIELDS);
    }

    private String getFieldDelimiter() {
        return this.fieldDelimiterTextField.getText();
    }

    private String getJoinDelimiter() {
        return this.joinDelimiterTextField.getText();
    }

    private List<Integer> getFields() {
        String[] split;
        String fields = this.fieldsTextField.getText();
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Integer> toret = new LinkedList<Integer>();
        for (String field : split = fields.split(",")) {
            try {
                Integer fieldInt = Integer.parseInt(field) - 1;
                if (toret.contains(fieldInt)) continue;
                toret.add(fieldInt);
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }
        return toret;
    }

    private FieldSplitRenamer.Mode getMode() {
        return (FieldSplitRenamer.Mode)((Object)this.modeRbtnPanel.getSelectedItem().get());
    }

    @Override
    public boolean isValidConfiguration() {
        return !this.getFieldDelimiter().isEmpty() && !this.getFields().isEmpty();
    }

    @Override
    public HeaderRenamer getHeaderRenamer(HeaderTarget target) {
        return new FieldSplitRenamer(target, this.getFieldDelimiter(), this.getJoinDelimiter(), this.getMode(), this.getFields());
    }

    public void setHeaderRenamer(FieldSplitRenamer renamer) {
        this.fieldDelimiterTextField.setText(renamer.getFieldDelimiter());
        this.joinDelimiterTextField.setText(renamer.getJoinDelimiter());
        this.modeRbtnPanel.setSelectedItem((Object)renamer.getMode());
        this.fieldsTextField.setText(renamer.getFields().stream().map(i -> String.valueOf(i + 1)).collect(Collectors.joining(", ")));
    }
}

