/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.filtering.base;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.ComponentsListPanel;
import org.sing_group.seda.core.operations.BasePresence;
import org.sing_group.seda.gui.configuration_panel.filtering.base.BasePresenceConfigurationPanel;

public class MultipleBasePresenceConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BASE_PRESENCES = "seda.base.presences";
    private CustomComponentsListPanel basePresencesPanel;
    private List<BasePresence> oldValue;

    public MultipleBasePresenceConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.basePresencesPanel = new CustomComponentsListPanel(1);
        this.add((Component)((Object)this.basePresencesPanel));
    }

    private void configurationChanged() {
        List<BasePresence> newValue = this.getBasePresences();
        this.firePropertyChange(PROPERTY_BASE_PRESENCES, this.oldValue, newValue);
        this.oldValue = newValue;
    }

    public List<BasePresence> getBasePresences() {
        if (!this.isValidValue()) {
            return Collections.emptyList();
        }
        if (this.basePresencesPanel != null) {
            return this.basePresencesPanel.getComponentsList().stream().map(BasePresenceConfigurationPanel::getBasePresence).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isValidValue() {
        if (this.basePresencesPanel != null) {
            for (BasePresenceConfigurationPanel panel : this.basePresencesPanel.getComponentsList()) {
                if (panel.isValidValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setBasePresences(List<BasePresence> basePresences) {
        this.basePresencesPanel.removeAllComponents();
        basePresences.forEach(this.basePresencesPanel::addNewBasePresence);
    }

    private class CustomComponentsListPanel
    extends ComponentsListPanel<BasePresenceConfigurationPanel> {
        private static final long serialVersionUID = 1L;

        public CustomComponentsListPanel(int initialComponents) {
            super(initialComponents);
        }

        protected BasePresenceConfigurationPanel getGenericComponent() {
            BasePresenceConfigurationPanel component = new BasePresenceConfigurationPanel();
            this.addListener(component);
            return component;
        }

        private void addListener(BasePresenceConfigurationPanel component) {
            component.addPropertyChangeListener("seda.base.presence", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MultipleBasePresenceConfigurationPanel.this.configurationChanged();
                }
            });
        }

        protected String getAddComponentButtonLabel() {
            return "Add new base filter";
        }

        protected void addComponentWrapPanelComponent() {
            super.addComponentWrapPanelComponent();
            MultipleBasePresenceConfigurationPanel.this.configurationChanged();
        }

        protected void removeComponentWrapPanel(ComponentsListPanel.ComponentWrapPanel component) {
            super.removeComponentWrapPanel(component);
            MultipleBasePresenceConfigurationPanel.this.configurationChanged();
        }

        public void removeAllComponents() {
            super.removeAllComponents();
            MultipleBasePresenceConfigurationPanel.this.configurationChanged();
        }

        public void addNewBasePresence(BasePresence basePresence) {
            super.addComponentWrapPanelComponent(() -> {
                BasePresenceConfigurationPanel component = new BasePresenceConfigurationPanel(basePresence);
                this.addListener(component);
                return component;
            });
            MultipleBasePresenceConfigurationPanel.this.configurationChanged();
        }
    }
}

