/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.DoubleTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.bio.SequenceType;
import org.sing_group.seda.bio.consensus.ConsensusBaseStrategy;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.gui.configuration_panel.ReformatFastaConfigurationPanel;
import org.sing_group.seda.plugin.core.info.plugin.GenerateConsensusSequenceSedaPluginInfo;
import org.sing_group.seda.transformation.provider.consensus.GenerateConsensusSequenceTransformationProvider;

public class GenerateConsensusSequenceConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_SEQUENCE_TYPE = GenerateConsensusSequenceSedaPluginInfo.PARAM_SEQUENCE_TYPE_HELP_GUI;
    private static final String HELP_CONSENSUS_BASE_STRATEGY = GenerateConsensusSequenceSedaPluginInfo.PARAM_CONSENSUS_BASE_HELP_GUI;
    private static final String HELP_MINIMUM_PRESENCE = GenerateConsensusSequenceSedaPluginInfo.PARAM_MINIMUM_PRESENCE_HELP_GUI;
    private static final String HELP_VERBOSE = GenerateConsensusSequenceSedaPluginInfo.PARAM_VERBOSE_HELP_GUI;
    private GenerateConsensusSequenceTransformationProvider transformationProvider;
    private ReformatFastaConfigurationPanel reformatPanel;
    private JComboBox<SequenceType> sequenceTypeCombobox;
    private JComboBox<ConsensusBaseStrategy> consensusBaseStrategyCombobox;
    private DoubleTextField minimumPresenceTextField;
    private JCheckBox verboseCheckBox;

    public GenerateConsensusSequenceConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getParametersPanel());
        mainPanel.add(this.getReformatFastaConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private Component getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getSequenceTypeParameter());
        parameters.add(this.getConsensusBaseStrategyParameter());
        parameters.add(this.getMinimumPresenceParameter());
        parameters.add(this.getVerboseParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getSequenceTypeParameter() {
        this.sequenceTypeCombobox = new JComboBox<SequenceType>(SequenceType.values());
        this.sequenceTypeCombobox.addItemListener(this::sequenceTypeChanged);
        return new InputParameter("Sequence type: ", this.sequenceTypeCombobox, HELP_SEQUENCE_TYPE);
    }

    private void sequenceTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.sequenceTypeChanged();
        }
    }

    private void sequenceTypeChanged() {
        this.transformationProvider.setSequenceType(this.getSequenceType());
        this.verboseCheckBox.setEnabled(this.getSequenceType().equals((Object)SequenceType.PROTEIN));
    }

    private InputParameter getConsensusBaseStrategyParameter() {
        this.consensusBaseStrategyCombobox = new JComboBox<ConsensusBaseStrategy>(ConsensusBaseStrategy.values());
        this.consensusBaseStrategyCombobox.addItemListener(this::consensusBaseStrategyChanged);
        return new InputParameter("Consensus bases: ", this.consensusBaseStrategyCombobox, HELP_CONSENSUS_BASE_STRATEGY);
    }

    private void consensusBaseStrategyChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.consensusBaseStrategyChanged();
        }
    }

    private void consensusBaseStrategyChanged() {
        this.transformationProvider.setConsensusBaseStrategy(this.getConsensusBaseStrategy());
    }

    private InputParameter getMinimumPresenceParameter() {
        this.minimumPresenceTextField = new DoubleTextField(0.5);
        this.minimumPresenceTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                GenerateConsensusSequenceConfigurationPanel.this.minimumPresenceValueChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                GenerateConsensusSequenceConfigurationPanel.this.minimumPresenceValueChanged();
            }
        });
        return new InputParameter("Minimum presence: ", (JComponent)this.minimumPresenceTextField, HELP_MINIMUM_PRESENCE);
    }

    private void minimumPresenceValueChanged() {
        SwingUtilities.invokeLater(() -> {
            boolean valid = this.isValidMinimumPresenceValue();
            this.minimumPresenceTextField.setBackground(valid ? null : GuiUtils.COLOR_ERROR);
            this.transformationProvider.setMinimumPresence(this.getMinimumPresence());
        });
    }

    private boolean isValidMinimumPresenceValue() {
        double value = this.getMinimumPresence();
        return value >= 0.0 && value <= 1.0;
    }

    private InputParameter getVerboseParameter() {
        this.verboseCheckBox = new JCheckBox();
        this.verboseCheckBox.addItemListener(e -> this.verboseChanged());
        return new InputParameter("Verbose: ", (JComponent)this.verboseCheckBox, HELP_VERBOSE);
    }

    private void verboseChanged() {
        this.transformationProvider.setVerbose(this.isVerbose());
    }

    private Component getReformatFastaConfigurationPanel() {
        this.reformatPanel = new ReformatFastaConfigurationPanel();
        this.reformatPanel.setBorder(BorderFactory.createTitledBorder("Reformat output file"));
        return this.reformatPanel;
    }

    private void initTransformationProvider() {
        this.transformationProvider = new GenerateConsensusSequenceTransformationProvider();
        this.transformationProvider.setReformatFastaTransformationProvider(this.reformatPanel.getTransformationProvider());
        this.consensusBaseStrategyChanged();
        this.minimumPresenceValueChanged();
        this.sequenceTypeChanged();
        this.verboseChanged();
    }

    public GenerateConsensusSequenceTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    private SequenceType getSequenceType() {
        return (SequenceType)((Object)this.sequenceTypeCombobox.getSelectedItem());
    }

    private ConsensusBaseStrategy getConsensusBaseStrategy() {
        return (ConsensusBaseStrategy)((Object)this.consensusBaseStrategyCombobox.getSelectedItem());
    }

    private double getMinimumPresence() {
        return this.minimumPresenceTextField.getValue();
    }

    private boolean isVerbose() {
        return this.verboseCheckBox.isSelected();
    }

    public void setTransformationProvider(GenerateConsensusSequenceTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.verboseCheckBox.setSelected(this.transformationProvider.isVerbose());
        this.minimumPresenceTextField.setValue((Object)this.transformationProvider.getMinimumPresence());
        this.sequenceTypeCombobox.setSelectedItem((Object)this.transformationProvider.getSequenceType());
        this.consensusBaseStrategyCombobox.setSelectedItem((Object)this.transformationProvider.getConsensusBaseStrategy());
        this.reformatPanel.setTransformationProvider(this.transformationProvider.getReformatFastaTransformationProvider());
    }
}

