/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sing_group.seda.gui.PathSelectionModelEvent;
import org.sing_group.seda.gui.PathSelectionModelListener;

public class PathSelectionModel {
    private final List<String> availablePaths = new ArrayList<String>();
    private final List<String> selectedPaths = new ArrayList<String>();
    private final List<PathSelectionModelListener> listeners = new CopyOnWriteArrayList<PathSelectionModelListener>();

    public Stream<String> getAvailablePaths() {
        return this.availablePaths.stream();
    }

    public Stream<String> getSelectedPaths() {
        return this.selectedPaths.stream();
    }

    public int countAvailablePaths() {
        return this.availablePaths.size();
    }

    public int countSelectedPaths() {
        return this.selectedPaths.size();
    }

    public String getAvailablePath(int index) {
        return this.availablePaths.get(index);
    }

    public String getSelectedPath(int index) {
        return this.selectedPaths.get(index);
    }

    public void clearAvailablePaths() {
        if (this.availablePaths.size() > 0) {
            int lastIndex = this.availablePaths.size() - 1;
            this.availablePaths.clear();
            this.firePathSelectionPanelModelEvent(PathSelectionModelEvent.of(PathSelectionModelEvent.FileSelectionEventType.CLEAR_AVAILABLE, lastIndex));
        }
    }

    public void clearSelectedPaths() {
        if (this.selectedPaths.size() > 0) {
            int lastIndex = this.selectedPaths.size() - 1;
            this.selectedPaths.clear();
            this.firePathSelectionPanelModelEvent(PathSelectionModelEvent.of(PathSelectionModelEvent.FileSelectionEventType.CLEAR_SELECTED, lastIndex));
        }
    }

    public void addAvailablePath(Path path) {
        this.addAvailablePath(path.toAbsolutePath().toString());
    }

    public void addAvailablePath(String path) {
        if (!this.selectedPaths.contains(path) && !this.availablePaths.contains(path)) {
            this.availablePaths.add(path);
            Collections.sort(this.availablePaths);
            this.firePathSelectionPanelModelEvent(PathSelectionModelEvent.of(PathSelectionModelEvent.FileSelectionEventType.ADD_AVAILABLE, path, this.availablePaths.indexOf(path)));
        }
    }

    public void addAvailablePaths(Path ... paths) {
        Arrays.stream(paths).forEach(this::addAvailablePath);
    }

    public void addAvailablePaths(String ... paths) {
        Arrays.stream(paths).forEach(this::addAvailablePath);
    }

    public void selectPath(Path path) {
        this.selectPath(path.toAbsolutePath().toString());
    }

    public void selectPath(String path) {
        if (this.availablePaths.contains(path)) {
            int index = this.availablePaths.indexOf(path);
            this.availablePaths.remove(path);
            this.firePathSelectionPanelModelEvent(PathSelectionModelEvent.of(PathSelectionModelEvent.FileSelectionEventType.REMOVE_AVAILABLE, path, index));
            this.selectedPaths.add(path);
            Collections.sort(this.selectedPaths);
            this.firePathSelectionPanelModelEvent(PathSelectionModelEvent.of(PathSelectionModelEvent.FileSelectionEventType.ADD_SELECTED, path, this.selectedPaths.indexOf(path)));
        }
    }

    public void selectPaths(Path ... paths) {
        Arrays.stream(paths).forEach(this::selectPath);
    }

    public void selectPaths(String ... paths) {
        Arrays.stream(paths).forEach(this::selectPath);
    }

    public void removeSelectedPath(Path path) {
        this.removeSelectedPath(path.toAbsolutePath().toString());
    }

    public void removeSelectedPath(String path) {
        if (this.selectedPaths.contains(path)) {
            int index = this.selectedPaths.indexOf(path);
            this.selectedPaths.remove(path);
            this.firePathSelectionPanelModelEvent(PathSelectionModelEvent.of(PathSelectionModelEvent.FileSelectionEventType.REMOVE_SELECTED, path, index));
            this.addAvailablePath(path);
        }
    }

    public void removeSelectedPaths(Path ... paths) {
        Arrays.stream(paths).forEach(this::removeSelectedPath);
    }

    public void removeSelectedPaths(String ... paths) {
        Arrays.stream(paths).forEach(this::removeSelectedPath);
    }

    public void addPathSelectionModelListener(PathSelectionModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removePathSelectionModelListener(PathSelectionModelListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean containsPathSelectionModelListener(PathSelectionModelListener listener) {
        return this.listeners.contains(listener);
    }

    private void firePathSelectionPanelModelEvent(PathSelectionModelEvent event) {
        this.listeners.forEach(listener -> listener.modelChanged(event));
    }

    public void saveAvailablePaths(Path path) throws IOException {
        this.writeToFile(path, this.getAvailablePaths().collect(Collectors.joining(System.lineSeparator())));
    }

    public void saveSelectedPaths(Path path) throws IOException {
        this.writeToFile(path, this.getSelectedPaths().collect(Collectors.joining(System.lineSeparator())));
    }

    private void writeToFile(Path path, String str) throws IOException {
        Files.write(path, str.getBytes(), new OpenOption[0]);
    }
}

