/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.InMemorySequence;
import org.sing_group.seda.datatype.InMemorySequencesGroup;
import org.sing_group.seda.datatype.InMemorySequencesGroupDataset;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.IOUtils;

public class InMemoryDatatypeFactory
implements DatatypeFactory {
    private final boolean charsetSupport;

    public InMemoryDatatypeFactory() {
        this(false);
    }

    public InMemoryDatatypeFactory(boolean charsetSupport) {
        this.charsetSupport = charsetSupport;
    }

    @Override
    public Sequence newSequence(String name, String description, String sequence, Map<String, Object> properties) {
        return new InMemorySequence(name, description, sequence, properties);
    }

    @Override
    public SequencesGroup newSequencesGroup(Path file) {
        try {
            Charset charset = this.charsetSupport ? IOUtils.detectCharset(file) : null;
            return new InMemorySequencesGroup(file, charset);
        }
        catch (IOException e) {
            throw new RuntimeException("Error detecting charset", e);
        }
    }

    @Override
    public SequencesGroup newSequencesGroup(String name, Map<String, Object> properties, Sequence ... sequences) {
        return new InMemorySequencesGroup(name, properties, sequences);
    }

    @Override
    public SequencesGroup newSequencesGroup(String name, Map<String, Object> properties, List<Sequence> sequences) {
        return this.newSequencesGroup(name, properties, sequences.toArray(new Sequence[sequences.size()]));
    }

    @Override
    public SequencesGroupDataset newSequencesGroupDataset(SequencesGroup ... sequencesGroups) {
        return new InMemorySequencesGroupDataset(sequencesGroups);
    }
}

