/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.split;

import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.split.AbstractSequencesGroupSplitter;
import org.sing_group.seda.core.split.DefaultSequencesSort;
import org.sing_group.seda.core.split.SequencesSort;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.TransformationException;

public class NumberOfFilesSplitter
extends AbstractSequencesGroupSplitter {
    private int numFiles;

    public NumberOfFilesSplitter(int numFiles) {
        this(numFiles, new DefaultSequencesSort());
    }

    public NumberOfFilesSplitter(int numFiles, DatatypeFactory factory) {
        this(numFiles, new DefaultSequencesSort(), factory);
    }

    public NumberOfFilesSplitter(int numFiles, SequencesSort sequencesSort) {
        this(numFiles, sequencesSort, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public NumberOfFilesSplitter(int numFiles, SequencesSort sequencesSort, DatatypeFactory factory) {
        super(sequencesSort, factory);
        this.numFiles = numFiles;
    }

    @Override
    public List<SequencesGroup> split(SequencesGroup group) {
        if (this.numFiles > group.getSequenceCount()) {
            throw new TransformationException("The required number of files must be less than or equal to the actual number of sequences.");
        }
        LinkedList<SequencesGroup> toret = new LinkedList<SequencesGroup>();
        List<Sequence> input = this.getInputSequencesGroup(group);
        int partitionSize = Math.round(group.getSequenceCount() / this.numFiles);
        for (int i = 0; i < this.numFiles; ++i) {
            int startIndex = i * partitionSize;
            int endIndex = i == this.numFiles - 1 ? input.size() : (i + 1) * partitionSize;
            List<Sequence> currentSubList = input.subList(startIndex, endIndex);
            toret.add(this.createGroup(group.getName() + "_" + (i + 1), group.getProperties(), currentSubList));
        }
        return toret;
    }
}

