/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.split;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.split.SequencesGroupSplitter;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.util.OsUtils;

public class HeaderMatcherSplitter
implements SequencesGroupSplitter {
    private static final String UNMATCHED_SEQUENCES_GROUP = "Unmatched";
    private HeaderMatcher matcher;
    private DatatypeFactory factory;
    private File groupNamesDirectory;

    public HeaderMatcherSplitter(HeaderMatcher headerMatcher) {
        this(headerMatcher, null, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public HeaderMatcherSplitter(HeaderMatcher headerMatcher, File groupNamesDirectory) {
        this(headerMatcher, groupNamesDirectory, DatatypeFactory.getDefaultDatatypeFactory());
    }

    public HeaderMatcherSplitter(HeaderMatcher headerMatcher, File groupNamesDirectory, DatatypeFactory factory) {
        this.matcher = headerMatcher;
        this.factory = factory;
        this.groupNamesDirectory = groupNamesDirectory;
    }

    @Override
    public List<SequencesGroup> split(SequencesGroup sequencesGroup) {
        String groupName = sequencesGroup.getName();
        LinkedList<SequencesGroup> groups = new LinkedList<SequencesGroup>();
        HashMap groupsMap = new HashMap();
        sequencesGroup.getSequences().forEach(s -> {
            Optional<String> match = this.matcher.match((Sequence)s);
            String key = match.orElse(UNMATCHED_SEQUENCES_GROUP);
            groupsMap.putIfAbsent(key, new LinkedList());
            ((List)groupsMap.get(key)).add(s);
        });
        Map<String, String> getGroupNamesMap = this.getGroupNamesMap(groupsMap.keySet());
        groupsMap.keySet().forEach(key -> {
            String groupNameForFileName = (String)getGroupNamesMap.get(key);
            SequencesGroup newGroup = this.factory.newSequencesGroup(groupName + "_" + groupNameForFileName, sequencesGroup.getProperties(), (List)groupsMap.get(key));
            groups.add(newGroup);
        });
        if (this.groupNamesDirectory != null) {
            try {
                this.saveGroupNamesDirectory(sequencesGroup.getName(), groupsMap.keySet());
            }
            catch (IOException e) {
                throw new TransformationException(e);
            }
        }
        return groups;
    }

    private Map<String, String> getGroupNamesMap(Set<String> keySet) {
        LinkedList<String> keys = new LinkedList<String>(keySet);
        if (OsUtils.isWindows()) {
            return HeaderMatcherSplitter.getUniqueNames(keys);
        }
        return keys.stream().collect(Collectors.toMap(k -> k, k -> k));
    }

    private void saveGroupNamesDirectory(String name, Set<String> keySet) throws IOException {
        Files.write(new File(this.groupNamesDirectory, name + ".txt").toPath(), keySet.stream().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static final Map<String, String> getUniqueNames(List<String> strings) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, String> toret = new HashMap<String, String>();
        HashSet<Integer> toSkip = new HashSet<Integer>();
        for (int i = 0; i < strings.size(); ++i) {
            if (toSkip.contains(i)) continue;
            String a = strings.get(i);
            counts.putIfAbsent(a.toLowerCase(), 1);
            for (int j = i + 1; j < strings.size(); ++j) {
                String b;
                if (toSkip.contains(j) || !a.equalsIgnoreCase(b = strings.get(j))) continue;
                toret.putIfAbsent(a, a + "_" + counts.get(a.toLowerCase()));
                toret.putIfAbsent(b, b + "_" + ((Integer)counts.get(a.toLowerCase()) + 1));
                counts.put(a.toLowerCase(), (Integer)counts.get(a.toLowerCase()) + 1);
                toSkip.add(j);
            }
            toret.putIfAbsent(a, a);
        }
        return toret;
    }
}

