/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.filtering;

import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.filtering.RegexConfiguration;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.filtering.SequenceNameHeaderMatcher;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.util.StringUtils;

@XmlRootElement
public class HeaderFilteringConfiguration {
    @XmlElement
    private boolean useFilter;
    @XmlElement
    private Mode mode;
    @XmlElement
    private Level level;
    @XmlElement
    private int min;
    @XmlElement
    private int max;
    @XmlElement
    private FilterType filterType;
    @XmlElement
    private String filterString;
    @XmlElement
    private boolean quotePattern;
    @XmlElement
    private int regexGroup;
    @XmlElement
    private boolean caseSensitive;
    @XmlElement
    private HeaderTarget headerTarget;

    public HeaderFilteringConfiguration() {
        this(false, Mode.KEEP, Level.SEQUENCE, 0, 0, FilterType.SEQUENCE_NAME, null, false, 0, false, HeaderTarget.ALL);
    }

    public HeaderFilteringConfiguration(boolean useFilter, Mode mode, Level level, int min, int max, FilterType filterType, String filterString, boolean quotePattern, int regexGroup, boolean caseSensitive, HeaderTarget headerTarget) {
        this.useFilter = useFilter;
        this.mode = mode;
        this.level = level;
        this.min = min;
        this.max = max;
        this.filterType = filterType;
        this.filterString = filterString;
        this.quotePattern = quotePattern;
        this.regexGroup = regexGroup;
        this.caseSensitive = caseSensitive;
        this.headerTarget = headerTarget;
    }

    public Validation validate() {
        if (!this.useFilter) {
            return new DefaultValidation(new String[0]);
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.isValidRange()) {
            errors.add("The specified range is not valid (min > max)");
        }
        if (this.mode == null) {
            errors.add("The mode can't be null.");
        }
        if (this.level == null) {
            errors.add("The level can't be null.");
        }
        if (this.filterType == null) {
            errors.add("The filter type can't be null.");
        }
        if (this.headerTarget == null) {
            errors.add("The header target can't be null.");
        }
        if (this.filterType == null) {
            errors.add("The filter type can't be null.");
        }
        try {
            this.getHeaderMatcher();
        }
        catch (PatternSyntaxException e) {
            errors.add("The regular expression configuration is not valid.");
        }
        return new DefaultValidation(errors);
    }

    private boolean isValidRange() {
        return this.min <= this.max;
    }

    public boolean isUseFilter() {
        return this.useFilter;
    }

    public boolean isQuotePattern() {
        return this.quotePattern;
    }

    public int getRegexGroup() {
        return this.regexGroup;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Level getLevel() {
        return this.level;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public Mode getMode() {
        return this.mode;
    }

    public HeaderTarget getHeaderTarget() {
        return this.headerTarget;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseSensitive ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.filterType == null ? 0 : this.filterType.hashCode());
        result = 31 * result + (this.headerTarget == null ? 0 : this.headerTarget.hashCode());
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + this.regexGroup;
        result = 31 * result + (this.useFilter ? 1231 : 1237);
        result = 31 * result + (this.quotePattern ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderFilteringConfiguration other = (HeaderFilteringConfiguration)obj;
        if (this.caseSensitive != other.caseSensitive) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.filterType != other.filterType) {
            return false;
        }
        if (this.headerTarget != other.headerTarget) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.regexGroup != other.regexGroup) {
            return false;
        }
        if (this.useFilter != other.useFilter) {
            return false;
        }
        return this.quotePattern == other.quotePattern;
    }

    public HeaderMatcher getHeaderMatcher() {
        if (this.getFilterType().equals((Object)FilterType.SEQUENCE_NAME)) {
            return new SequenceNameHeaderMatcher();
        }
        RegexConfiguration regexConfiguration = new RegexConfiguration(this.isCaseSensitive(), this.getRegexGroup(), this.isQuotePattern());
        return new RegexHeaderMatcher(this.getFilterString(), this.getHeaderTarget(), regexConfiguration);
    }

    public static enum Level {
        SEQUENCE,
        FILE;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }

    public static enum FilterType {
        SEQUENCE_NAME("Sequence name"),
        REGEX("Regular expression");

        private String description;

        private FilterType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Mode {
        KEEP,
        REMOVE;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }
}

