/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.execution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.sing_group.seda.core.execution.BinaryCheckException;

public class BinaryCheckingUtils {
    public static void checkCommand(String command, int expectedOutputLinesCount) throws BinaryCheckException {
        BinaryCheckingUtils.checkCommand(command, expectedOutputLinesCount, 0);
    }

    public static void checkCommand(String command, int expectedOutputLinesCount, int expectedExitStatus) throws BinaryCheckException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            Process process = runtime.exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder sb = new StringBuilder();
            int countLines = 0;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
                ++countLines;
            }
            if (countLines != expectedOutputLinesCount) {
                throw new BinaryCheckException("Unrecognized version output", command);
            }
            int exitStatus = process.waitFor();
            if (exitStatus != expectedExitStatus) {
                throw new BinaryCheckException("Invalid exit status: " + exitStatus, command);
            }
        }
        catch (IOException e) {
            throw new BinaryCheckException("Error while checking version", e, command);
        }
        catch (InterruptedException e) {
            throw new BinaryCheckException("Error while checking version", e, command);
        }
    }

    public static void checkCommand(String command, List<String> firstOutputLines) throws BinaryCheckException {
        BinaryCheckingUtils.checkCommand(command, firstOutputLines, Process::getInputStream);
    }

    public static void checkCommandErrorOutput(String command, List<String> firstOutputLines) throws BinaryCheckException {
        BinaryCheckingUtils.checkCommand(command, firstOutputLines, Process::getErrorStream);
    }

    public static void checkCommand(String command, List<String> firstOutputLines, Function<Process, InputStream> processStream) throws BinaryCheckException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            Process process = runtime.exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(processStream.apply(process)));
            LinkedList<String> output = new LinkedList<String>();
            while ((line = br.readLine()) != null) {
                output.add(line);
            }
            boolean equals = true;
            for (int i = 0; i < firstOutputLines.size(); ++i) {
                String a = firstOutputLines.get(i);
                try {
                    String b = (String)output.get(i);
                    equals = a.equals(b);
                }
                catch (IndexOutOfBoundsException e) {
                    equals = false;
                }
                if (equals) continue;
                throw new BinaryCheckException("Unrecognized version output", command);
            }
            process.waitFor();
        }
        catch (IOException e) {
            throw new BinaryCheckException("Error while checking version", e, command);
        }
        catch (InterruptedException e) {
            throw new BinaryCheckException("Error while checking version", e, command);
        }
    }
}

