/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.comparator.SequenceComparator;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.plugin.core.info.plugin.SortSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.sort.SortTransformationProvider;

public class SortCommand
extends SedaCommand {
    public static final DefaultValuedStringOption OPTION_SORT_ON = new DefaultValuedStringOption("sort-on", "so", SortSedaPluginInfo.PARAM_SORT_ON_HELP, SequenceTarget.SEQUENCE.name().toLowerCase());
    public static final FlagOption OPTION_DESCENDING = new FlagOption("descending", "des", "Use this option to sort in descending order.");
    public static final DefaultValuedStringOption OPTION_CRITERIA = new DefaultValuedStringOption("criteria", "c", SortSedaPluginInfo.PARAM_CRITERIA_HELP, SequenceComparator.LENGTH.name().toLowerCase());

    public String getName() {
        return "sort";
    }

    public String getDescriptiveName() {
        return "Sort";
    }

    public String getDescription() {
        return "Sort sequences by sequence length or sequence header (alphabetically).";
    }

    @Override
    protected String getSedaGroup() {
        return SortSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_SORT_ON, OPTION_DESCENDING, OPTION_CRITERIA);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        SortTransformationProvider provider = new SortTransformationProvider();
        SequenceTarget sequenceTarget = null;
        SequenceComparator sequenceComparator = null;
        try {
            sequenceTarget = SequenceTarget.valueOf(((String)parameters.getSingleValue((Option)OPTION_SORT_ON)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SortCommand.invalidEnumValue(OPTION_SORT_ON);
        }
        try {
            sequenceComparator = SequenceComparator.valueOf(((String)parameters.getSingleValue((Option)OPTION_CRITERIA)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SortCommand.invalidEnumValue(OPTION_CRITERIA);
        }
        provider.setSequenceTarget(sequenceTarget);
        provider.setSequenceComparator(sequenceComparator);
        provider.setDescendingSort(parameters.hasFlag((Option)OPTION_DESCENDING));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, SortTransformationProvider.class);
    }
}

