/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.MultipleSequencePatternCliParameters;
import org.sing_group.seda.cli.parameters.SequenceTranslationCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.plugin.core.info.plugin.ReallocateReferenceSequencesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.pattern.reallocate.ReallocateReferenceSequencesTransformationProvider;

public class ReallocateReferenceSequencesCommand
extends SedaCommand {
    public static final DefaultValuedStringOption OPTION_SEQUENCE_TARGET = new DefaultValuedStringOption("sequence-target", "st", ReallocateReferenceSequencesSedaPluginInfo.PARAM_SEQUENCE_TARGET_HELP, SequenceTarget.SEQUENCE.toString().toLowerCase());
    private SequenceTranslationCliParameters sequenceTranslationCliParameters;

    public String getName() {
        return "reallocate";
    }

    public String getDescriptiveName() {
        return "Reallocate reference sequences";
    }

    public String getDescription() {
        return "Find one or more sequences (i.e. the reference sequences) using a pattern filtering option and reallocate them at the beginning of the file.";
    }

    @Override
    protected String getSedaGroup() {
        return ReallocateReferenceSequencesSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        this.sequenceTranslationCliParameters = new SequenceTranslationCliParameters(true, false, "If this option is selected, then input nucleic acid sequences are translated into amino acid sequences before applying the sequence comparison. In this case, note that the input nucleic acid sequences are reported.");
        ArrayList optionList = new ArrayList();
        optionList.add((Option<?>)OPTION_SEQUENCE_TARGET);
        optionList.addAll(MultipleSequencePatternCliParameters.getOptionList());
        optionList.addAll(this.sequenceTranslationCliParameters.getOptionList());
        return optionList;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        ReallocateReferenceSequencesTransformationProvider provider = new ReallocateReferenceSequencesTransformationProvider();
        SequenceTarget headerTarget = null;
        try {
            headerTarget = SequenceTarget.valueOf(((String)parameters.getSingleValue((Option)OPTION_SEQUENCE_TARGET)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ReallocateReferenceSequencesCommand.invalidEnumValue(OPTION_SEQUENCE_TARGET);
        }
        provider.setTarget(headerTarget);
        if (headerTarget.isSequence() && this.sequenceTranslationCliParameters.hasConvertAminoAcid(parameters)) {
            try {
                provider.setTranslationConfiguration(this.sequenceTranslationCliParameters.getSequenceTranslationConfiguration(parameters));
            }
            catch (IllegalArgumentException e) {
                ReallocateReferenceSequencesCommand.formattedValidationError(e.getMessage());
            }
        }
        MultipleSequencePatternCliParameters patternParameters = new MultipleSequencePatternCliParameters(parameters);
        try {
            provider.setPattern(patternParameters.getSequencePatternGroup());
        }
        catch (IllegalArgumentException e) {
            ReallocateReferenceSequencesCommand.formattedValidationError(e.getMessage());
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, ReallocateReferenceSequencesTransformationProvider.class);
    }
}

