/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli;

import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.OptionCategory;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sing_group.seda.cli.SedaCommand;

public abstract class ExternalSoftwareExecutionCommand
extends SedaCommand {
    public static final List<OptionCategory> SOFTWARE_EXECUTION_CATEGORY = Arrays.asList(new OptionCategory("External dependencies options"));

    protected abstract List<Option<?>> getLocalOptionsList();

    protected abstract Map<Option<?>, String> getLocalOptionsToEnablePropertyMap();

    protected static Map<Option<?>, String> fromLists(List<Option<?>> keys, List<String> values) {
        HashMap toret = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            toret.put(keys.get(i), values.get(i));
        }
        return toret;
    }

    protected static Map<Option<?>, String> fromKeyValue(Option<?> key, String value) {
        return ExternalSoftwareExecutionCommand.fromLists(Arrays.asList(key), Arrays.asList(value));
    }

    protected abstract List<Option<?>> createExternalSedaOptions();

    @Override
    protected List<Option<?>> createSedaOptions() {
        return this.createExternalSedaOptions().stream().filter(this::filterOption).collect(Collectors.toList());
    }

    private boolean filterOption(Option<?> option) {
        return !this.getLocalOptionsList().contains(option) || this.isLocalExecutionEnabledForOption(option);
    }

    private boolean isLocalExecutionEnabledForOption(Option<?> option) {
        return !System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty(this.getLocalOptionsToEnablePropertyMap().get(option), "true").equals("false");
    }

    protected static void validateSingleExecutionMode(Parameters parameters, StringOption localMode, StringOption dockerMode) {
        ExternalSoftwareExecutionCommand.validateSingleExecutionMode(parameters, localMode, dockerMode, ", chose between " + ExternalSoftwareExecutionCommand.formatParam(localMode) + " or " + ExternalSoftwareExecutionCommand.formatParam(dockerMode));
    }

    public static void validateSingleExecutionMode(Parameters parameters, StringOption localMode, StringOption dockerMode, String customMessage) {
        if (parameters.hasOption((Option)localMode) && parameters.hasOption((Option)dockerMode)) {
            ExternalSoftwareExecutionCommand.formattedValidationError("Only one execution mode can be specified" + customMessage);
        }
    }
}

