/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bio.consensus;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sing_group.seda.bio.consensus.SequencesGroupConsensus;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.TransformationException;

public abstract class AbstractSequencesGroupMostFrequentConsensus
implements SequencesGroupConsensus {
    private SequenceBuilder sequenceBuilder;
    protected double minimumPresence;
    protected boolean verbose;

    public AbstractSequencesGroupMostFrequentConsensus(SequenceBuilder sequenceBuilder, double minimumPresence, boolean verbose) {
        this.minimumPresence = minimumPresence;
        this.sequenceBuilder = sequenceBuilder;
        this.verbose = verbose;
    }

    @Override
    public Sequence getConsensus(SequencesGroup sequencesGroup) {
        HashMap consensusMap = new HashMap();
        for (Object sequence : sequencesGroup.getSequences().collect(Collectors.toList())) {
            if (consensusMap.keySet().size() > 0 && consensusMap.keySet().size() != sequence.getLength()) {
                throw new TransformationException("All sequences must have the same length");
            }
            String string = sequence.getChain();
            for (int i = 0; i < string.length(); ++i) {
                Character charAt = Character.valueOf(string.charAt(i));
                consensusMap.putIfAbsent(i, new HashMap());
                ((Map)consensusMap.get(i)).putIfAbsent(charAt, 0);
                ((Map)consensusMap.get(i)).put(charAt, (Integer)((Map)consensusMap.get(i)).get(charAt) + 1);
            }
        }
        StringBuilder consensusChain = new StringBuilder();
        for (Map.Entry entry : consensusMap.entrySet()) {
            int maxCount = 0;
            LinkedList<Character> maxCharacter = new LinkedList<Character>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if ((Integer)entry2.getValue() > maxCount) {
                    maxCount = (Integer)entry2.getValue();
                    maxCharacter.clear();
                    maxCharacter.add((Character)entry2.getKey());
                    continue;
                }
                if ((Integer)entry2.getValue() != maxCount) continue;
                maxCharacter.add((Character)entry2.getKey());
            }
            double maxPresence = (double)maxCount / (double)sequencesGroup.getSequenceCount();
            if (maxCharacter.size() == 1 && maxPresence >= this.minimumPresence) {
                consensusChain.append(maxCharacter.get(0));
                continue;
            }
            consensusChain.append(this.solveAmbiguity(maxCharacter, maxPresence));
        }
        Sequence consensus = this.sequenceBuilder.of("consensus_" + sequencesGroup.getName(), "", consensusChain.toString(), Collections.emptyMap());
        return consensus;
    }

    protected abstract String solveAmbiguity(List<Character> var1, double var2);
}

