/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.prosplign.execution.AbstractProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.ProSplignCompartEnvironment;

@XmlRootElement
public class DefaultProSplignCompartBinariesExecutor
extends AbstractProSplignCompartBinariesExecutor {
    @XmlTransient
    private final ProSplignCompartEnvironment environment = ProSplignCompartEnvironment.getInstance();
    @XmlElement
    private final File proSplignCompartDirectory;
    @XmlTransient
    private Optional<Path> directoryPath;

    public DefaultProSplignCompartBinariesExecutor() {
        this(null);
    }

    public DefaultProSplignCompartBinariesExecutor(File proSplignCompartDirectory) {
        this.proSplignCompartDirectory = proSplignCompartDirectory;
    }

    private Optional<Path> getDirectoryPath() {
        if (this.directoryPath == null) {
            this.directoryPath = this.proSplignCompartDirectory == null ? Optional.empty() : Optional.of(this.proSplignCompartDirectory.toPath());
        }
        return this.directoryPath;
    }

    @Override
    public void proSplign(File compart, File nucleotidesFasta, File proteinQueryFasta, File outputDir, String outputFileName) throws IOException, InterruptedException {
        super.proSplign(Arrays.asList(this.composeCommand(this.environment.getProSplignCommand())), compart, nucleotidesFasta, proteinQueryFasta, outputDir, outputFileName);
    }

    @Override
    public void proCompart(File database, File outputFile) throws IOException, InterruptedException {
        super.proCompart(Arrays.asList(this.composeCommand(this.environment.getProCompartCommand())), database, outputFile);
    }

    @Override
    protected String composeCommand(String command) {
        return this.getDirectoryPath().map(path -> path.resolve(command)).orElse(Paths.get(command, new String[0])).toString();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public File getProSplignCompartDirectory() {
        return this.proSplignCompartDirectory;
    }
}

