/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.provider.uniprot;

import java.util.LinkedList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.transformation.dataset.UniProtBlastTransformation;
import org.sing_group.seda.blast.transformation.provider.uniprot.UniProtBlastTransformationConfigurationChangeType;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.AlignmentCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ExpectationOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.MatrixOption;

@XmlRootElement
public class UniProtBlastTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private DatabaseOption database;
    @XmlElement
    private OutputTypeParameter outputType;
    @XmlElement
    private ExpectationOption expectValue;
    @XmlElement
    private MatrixOption matrix;
    @XmlElement
    private FilterOption filter;
    @XmlElement
    private boolean gapped;
    @XmlElement
    private AlignmentCutoffOption hits;

    public UniProtBlastTransformationProvider() {
    }

    public UniProtBlastTransformationProvider(DatabaseOption database, OutputTypeParameter outputType, ExpectationOption expectValue, MatrixOption matrix, FilterOption filter, boolean gapped, AlignmentCutoffOption hits) {
        this.database = database;
        this.outputType = outputType;
        this.expectValue = expectValue;
        this.matrix = matrix;
        this.filter = filter;
        this.gapped = gapped;
        this.hits = hits;
    }

    @Override
    public Validation validate() {
        LinkedList<String> validationErrors = new LinkedList<String>();
        if (this.database == null) {
            validationErrors.add("The database can't be null");
        }
        if (this.outputType == null) {
            validationErrors.add("The output type can't be null");
        }
        if (this.expectValue == null) {
            validationErrors.add("The expectation value can't be null");
        }
        if (this.matrix == null) {
            validationErrors.add("The matrix can't be null");
        }
        if (this.filter == null) {
            validationErrors.add("The filter can't be null");
        }
        if (this.hits == null) {
            validationErrors.add("The hits option can't be null");
        }
        if (validationErrors.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(validationErrors);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        if (!this.isValidTransformation()) {
            throw new IllegalStateException("The current transformation configuration is not valid");
        }
        return new UniProtBlastTransformation(this.database, this.outputType, this.expectValue, this.matrix, this.filter, this.gapped, this.hits, factory);
    }

    public void setDatabase(DatabaseOption database) {
        if (this.database == null || !this.database.equals((Object)database)) {
            this.database = database;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.DATABASE_CHANGED, this.database);
        }
    }

    public DatabaseOption getDatabase() {
        return this.database;
    }

    public void setOutputType(OutputTypeParameter outputType) {
        if (this.outputType == null || !this.outputType.equals((Object)outputType)) {
            this.outputType = outputType;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.OUTPUT_TYPE_CHANGED, (Object)this.outputType);
        }
    }

    public OutputTypeParameter getOutputType() {
        return this.outputType;
    }

    public void setMatrix(MatrixOption matrix) {
        if (this.matrix == null || !this.matrix.equals((Object)matrix)) {
            this.matrix = matrix;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.MATRIX_CHANGED, this.matrix);
        }
    }

    public MatrixOption getMatrix() {
        return this.matrix;
    }

    public void setExpectation(ExpectationOption expectValue) {
        if (this.expectValue == null || !this.expectValue.equals((Object)expectValue)) {
            this.expectValue = expectValue;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.EXPECT_VALUE_CHANGED, this.expectValue);
        }
    }

    public ExpectationOption getExpectValue() {
        return this.expectValue;
    }

    public void setFilter(FilterOption filterOption) {
        if (this.filter == null || !this.filter.equals((Object)filterOption)) {
            this.filter = filterOption;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.FILTER_OPTION_CHANGED, this.filter);
        }
    }

    public FilterOption getFilter() {
        return this.filter;
    }

    public void setGapped(boolean gapped) {
        if (this.gapped != gapped) {
            this.gapped = gapped;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.GAPPED_VALUE_CHANGED, this.gapped);
        }
    }

    public boolean isGapped() {
        return this.gapped;
    }

    public void setHits(AlignmentCutoffOption hits) {
        if (this.hits == null || !this.hits.equals((Object)hits)) {
            this.hits = hits;
            this.fireTransformationsConfigurationModelEvent(UniProtBlastTransformationConfigurationChangeType.HITS_CHANGED, this.hits);
        }
    }

    public AlignmentCutoffOption getHits() {
        return this.hits;
    }
}

